/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.huskycore.commands.abstraction;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.interfaces.Command;
import com.huskydreaming.huskycore.commands.providers.CommandProvider;
import com.huskydreaming.huskycore.commands.providers.ConsoleCommandProvider;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.huskycore.interfaces.Parseable;
import com.huskydreaming.huskycore.registries.CommandRegistry;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommand
implements CommandExecutor,
Command,
TabCompleter {
    private final CommandRegistry commandRegistry;

    public AbstractCommand(HuskyPlugin huskyPlugin) {
        this.commandRegistry = huskyPlugin.getCommandRegistry();
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull org.bukkit.command.Command command, @NotNull String s, @NotNull String[] strings) {
        if (strings.length > 0) {
            Command subCommand = this.commandRegistry.getCommand(strings[0]);
            if (subCommand == null) {
                commandSender.sendMessage(this.getUsage().prefix(strings[0]));
                return true;
            }
            if (commandSender instanceof ConsoleCommandSender) {
                ConsoleCommandSender consoleCommandSender = (ConsoleCommandSender)commandSender;
                if (subCommand instanceof ConsoleCommandProvider) {
                    ConsoleCommandProvider consoleCommandProvider = (ConsoleCommandProvider)subCommand;
                    consoleCommandProvider.onCommand(consoleCommandSender, strings);
                    return true;
                }
            }
            if (commandSender instanceof Player) {
                Player player = (Player)commandSender;
                if (!player.hasPermission(this.getLabel() + "." + subCommand.getLabel().toLowerCase()) && !player.isOp()) {
                    commandSender.sendMessage(this.getPermission().prefix(new Object[0]));
                    return true;
                }
                if (subCommand instanceof PlayerCommandProvider) {
                    PlayerCommandProvider playerCommandProvider = (PlayerCommandProvider)subCommand;
                    playerCommandProvider.onCommand(player, strings);
                    return true;
                }
            }
            if (subCommand instanceof CommandProvider) {
                CommandProvider commandProvider = (CommandProvider)subCommand;
                commandProvider.onCommand(commandSender, strings);
                return true;
            }
        } else {
            this.onCommand(commandSender, strings);
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull org.bukkit.command.Command command, @NotNull String s, @NotNull String[] strings) {
        Command subCommand;
        if (strings.length == 1) {
            return this.commandRegistry.getCommands().stream().map(c -> c.getLabel().toLowerCase()).collect(Collectors.toList());
        }
        if (strings.length > 1 && (subCommand = this.commandRegistry.getCommand(strings[0].toLowerCase())) != null) {
            if (commandSender instanceof ConsoleCommandSender) {
                ConsoleCommandSender consoleCommandSender = (ConsoleCommandSender)commandSender;
                if (subCommand instanceof ConsoleCommandProvider) {
                    ConsoleCommandProvider consoleCommandProvider = (ConsoleCommandProvider)subCommand;
                    return consoleCommandProvider.onTabComplete(consoleCommandSender, strings);
                }
            }
            if (commandSender instanceof Player) {
                Player player = (Player)commandSender;
                if (subCommand instanceof PlayerCommandProvider) {
                    PlayerCommandProvider playerCommandProvider = (PlayerCommandProvider)subCommand;
                    return playerCommandProvider.onTabComplete(player, strings);
                }
            }
            if (subCommand instanceof CommandProvider) {
                CommandProvider commandProvider = (CommandProvider)subCommand;
                return commandProvider.onTabComplete(commandSender, strings);
            }
        }
        return List.of();
    }

    public abstract void onCommand(CommandSender var1, String[] var2);

    public abstract Parseable getUsage();

    public abstract Parseable getPermission();
}

