/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.huskycore;

import com.huskydreaming.huskycore.registries.CommandRegistry;
import com.huskydreaming.huskycore.registries.ServiceRegistry;
import com.huskydreaming.huskycore.services.implementations.DefaultServiceImpl;
import com.huskydreaming.huskycore.services.interfaces.DefaultService;
import java.util.Arrays;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class HuskyPlugin
extends JavaPlugin {
    protected CommandRegistry commandRegistry;
    protected ServiceRegistry serviceRegistry;

    public void onEnable() {
        this.commandRegistry = new CommandRegistry();
        this.serviceRegistry = new ServiceRegistry();
        this.serviceRegistry.register(DefaultService.class, new DefaultServiceImpl());
        this.serviceRegistry.deserialize(this);
    }

    protected void registerListeners(Listener ... listeners) {
        PluginManager pluginManager = this.getServer().getPluginManager();
        Arrays.asList(listeners).forEach(listener -> pluginManager.registerEvents(listener, (Plugin)this));
    }

    public <T> T provide(Class<T> tClass) {
        return this.serviceRegistry.provide(tClass);
    }

    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }
}

