/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.bouncyball.utilities;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder {
    private boolean enchanted = false;
    private String displayName = "Item";
    private List<String> lore = null;
    private Material material = Material.STONE;
    private int amount = 1;

    public static ItemBuilder create() {
        return new ItemBuilder();
    }

    public ItemBuilder setDisplayName(String displayName) {
        this.displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)displayName);
        return this;
    }

    public ItemBuilder setLore(@Nullable List<String> lore) {
        if (lore == null) {
            this.lore = new ArrayList<String>();
            return this;
        }
        this.lore = lore.stream().map(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s)).collect(Collectors.toList());
        return this;
    }

    public ItemBuilder setLore(String ... strings) {
        List<String> lore = List.of(strings);
        this.lore = lore.stream().map(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s)).collect(Collectors.toList());
        return this;
    }

    public ItemBuilder setEnchanted(boolean enchanted) {
        this.enchanted = enchanted;
        return this;
    }

    public ItemBuilder setMaterial(Material material) {
        this.material = material;
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public ItemStack buildPlayer(OfflinePlayer offlinePlayer) {
        ItemStack itemStack = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        if (skullMeta != null) {
            if (this.enchanted) {
                skullMeta.addEnchant(Enchantment.DURABILITY, 1, true);
            }
            skullMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            skullMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            skullMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
            skullMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            skullMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
            skullMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
            skullMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            skullMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            skullMeta.setDisplayName(this.displayName);
            skullMeta.setOwnerProfile(offlinePlayer.getPlayerProfile());
            if (this.lore != null) {
                skullMeta.setLore(this.lore);
            }
            itemStack.setItemMeta((ItemMeta)skullMeta);
        }
        return itemStack;
    }

    public ItemStack build() {
        ItemStack itemStack = new ItemStack(this.material);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            if (this.enchanted) {
                itemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
            }
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            itemMeta.setDisplayName(this.displayName);
            if (this.lore != null) {
                itemMeta.setLore(this.lore);
            }
            itemStack.setItemMeta(itemMeta);
        }
        itemStack.setAmount(this.amount);
        return itemStack;
    }
}

