/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.bouncyball.storage.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.huskydreaming.bouncyball.storage.enumeration.Extension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.bukkit.plugin.Plugin;

public class Json {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void write(Plugin plugin, String fileName, Object object) {
        Path path = Json.check(plugin, fileName);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson(object, (Appendable)bufferedWriter);
            plugin.getLogger().info("Serialized " + path.getFileName() + " successfully.");
        }
        catch (IOException e) {
            plugin.getLogger().severe(e.getMessage());
        }
    }

    public static <T> T read(Plugin plugin, String fileName, Type type) {
        Path path = Json.check(plugin, fileName);
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(Json.check(plugin, fileName), StandardCharsets.UTF_8);
            JsonReader jsonReader = new JsonReader((Reader)bufferedReader);
            Object t = GSON.fromJson(jsonReader, type);
            plugin.getLogger().info("Deserialized " + path.getFileName() + " successfully.");
            return (T)t;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Path check(Plugin plugin, String fileName) {
        String[] splitPath = fileName.split("/");
        String directoryPath = null;
        if (splitPath.length > 1) {
            directoryPath = splitPath[0] + File.separator;
        }
        String dataFolder = plugin.getDataFolder() + File.separator;
        Path path = Paths.get(dataFolder + fileName + Extension.JSON, new String[0]);
        try {
            if (!Files.exists(plugin.getDataFolder().toPath(), new LinkOption[0])) {
                Files.createDirectories(plugin.getDataFolder().toPath(), new FileAttribute[0]);
                plugin.getLogger().info("Creating new directory: " + plugin.getDataFolder());
            }
            if (!Files.exists(path, new LinkOption[0])) {
                if (directoryPath != null) {
                    Files.createDirectories(Paths.get(dataFolder + directoryPath, new String[0]), new FileAttribute[0]);
                }
                Files.createFile(path, new FileAttribute[0]);
                plugin.getLogger().info("Creating new file: " + path.getFileName());
            }
        }
        catch (IOException e) {
            plugin.getLogger().severe(e.getMessage());
        }
        return path;
    }
}

