/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.bouncyball.services.implementations;

import com.google.common.reflect.TypeToken;
import com.huskydreaming.bouncyball.BouncyBallPlugin;
import com.huskydreaming.bouncyball.data.ProjectileData;
import com.huskydreaming.bouncyball.data.ProjectileDefault;
import com.huskydreaming.bouncyball.data.ProjectilePhysics;
import com.huskydreaming.bouncyball.data.ProjectileSetting;
import com.huskydreaming.bouncyball.services.interfaces.ProjectileService;
import com.huskydreaming.bouncyball.storage.base.Json;
import com.huskydreaming.bouncyball.utilities.Util;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ProjectileServiceImpl
implements ProjectileService {
    private NamespacedKey projectileNameSpacedKey;
    private Map<String, ProjectileData> projectileDataMap;
    private final Map<Projectile, String> projectileMap = new ConcurrentHashMap<Projectile, String>();

    @Override
    public void deserialize(BouncyBallPlugin plugin) {
        Type type = new TypeToken<Map<String, ProjectileData>>(){}.getType();
        this.projectileDataMap = (Map)Json.read((Plugin)plugin, "data/projectiles", type);
        this.projectileNameSpacedKey = new NamespacedKey((Plugin)plugin, "BOUNCY_BALL");
        if (this.projectileDataMap != null) {
            return;
        }
        this.projectileDataMap = new ConcurrentHashMap<String, ProjectileData>();
        for (ProjectileDefault projectileDefault : ProjectileDefault.values()) {
            if (projectileDefault == ProjectileDefault.DEFAULT) continue;
            CharSequence[] strings = projectileDefault.name().toLowerCase().split("_");
            String string = Util.capitalize(String.join((CharSequence)"_", strings));
            this.projectileDataMap.put(string, projectileDefault.getProjectileData());
        }
    }

    @Override
    public void serialize(BouncyBallPlugin plugin) {
        Json.write((Plugin)plugin, "data/projectiles", this.projectileDataMap);
    }

    @Override
    public void launchProjectile(Plugin plugin, Player player, ItemStack itemStack, String key) {
        ProjectileData projectileData = this.projectileDataMap.get(key);
        if (projectileData.getSettings().contains((Object)ProjectileSetting.REMOVES)) {
            itemStack.setAmount(itemStack.getAmount() - 1);
        }
        Snowball projectile = (Snowball)player.launchProjectile(Snowball.class);
        PersistentDataContainer persistentDataContainer = projectile.getPersistentDataContainer();
        persistentDataContainer.set(this.projectileNameSpacedKey, PersistentDataType.STRING, (Object)key);
        double launchVelocity = projectileData.getPhysics(ProjectilePhysics.LAUNCH_VELOCITY);
        projectile.setVelocity(player.getLocation().getDirection().multiply(launchVelocity));
        projectile.setGlowing(projectileData.getSettings().contains((Object)ProjectileSetting.GLOWS));
        projectile.setItem(new ItemStack(projectileData.getMaterial()));
        projectile.setInvulnerable(true);
        projectile.setShooter((ProjectileSource)player);
        this.projectileMap.put((Projectile)projectile, key);
    }

    @Override
    public void dropProjectile(Projectile projectile) {
        ProjectileData projectileData = this.getDataFromProjectile(projectile);
        if (projectileData == null) {
            return;
        }
        if (!projectileData.getSettings().contains((Object)ProjectileSetting.DROPS)) {
            return;
        }
        Location location = projectile.getLocation();
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        ItemStack itemStack = this.getItemStackFromProjectile(projectile);
        if (itemStack == null) {
            return;
        }
        Item item = world.dropItem(location, itemStack);
        item.setGlowing(projectileData.getSettings().contains((Object)ProjectileSetting.GLOWS));
        if (projectileData.getSettings().contains((Object)ProjectileSetting.ITEM_NAME)) {
            item.setCustomNameVisible(true);
            item.setCustomName(this.getKeyFromProjectile(projectile));
        }
    }

    @Override
    public void onProjectileEnd(Projectile projectile) {
    }

    @Override
    public Projectile updateProjectile(Plugin plugin, Projectile projectile) {
        ProjectileData projectileData = this.getDataFromProjectile(projectile);
        if (projectileData == null) {
            return null;
        }
        BlockFace blockFace = Util.getInverseFace(projectile);
        if (blockFace == null) {
            return null;
        }
        Vector velocity = projectile.getVelocity();
        double speed = velocity.length();
        if ((speed *= projectileData.getPhysics(ProjectilePhysics.DAMPING)) > projectileData.getPhysics(ProjectilePhysics.THRESHOLD)) {
            Vector direction = new Vector(blockFace.getModX(), blockFace.getModY(), blockFace.getModZ());
            direction = direction.multiply(velocity.dot(direction)).multiply(2.0);
            String key = this.getKeyFromProjectile(projectile);
            Snowball newProjectile = (Snowball)projectile.getWorld().spawnEntity(projectile.getLocation(), projectile.getType());
            PersistentDataContainer persistentDataContainer = newProjectile.getPersistentDataContainer();
            persistentDataContainer.set(this.projectileNameSpacedKey, PersistentDataType.STRING, (Object)key);
            newProjectile.setGlowing(projectileData.getSettings().contains((Object)ProjectileSetting.GLOWS));
            newProjectile.setItem(this.getItemStackFromKey(key));
            newProjectile.setVelocity(velocity.subtract(direction).normalize().multiply(speed));
            newProjectile.setShooter(projectile.getShooter());
            newProjectile.setInvulnerable(true);
            return newProjectile;
        }
        this.onProjectileEnd(projectile);
        this.dropProjectile(projectile);
        this.removeProjectile(projectile);
        return null;
    }

    @Override
    public String getKeyFromItemStack(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        PersistentDataContainer persistentDataContainer = itemMeta.getPersistentDataContainer();
        return (String)persistentDataContainer.get(this.projectileNameSpacedKey, PersistentDataType.STRING);
    }

    @Override
    public ItemStack getItemStackFromKey(String key) {
        ProjectileData projectileData = this.projectileDataMap.get(key);
        if (projectileData == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(projectileData.getMaterial());
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        itemMeta.setDisplayName(ChatColor.RESET + Util.capitalize(key.replace("_", " ")));
        PersistentDataContainer persistentDataContainer = itemMeta.getPersistentDataContainer();
        persistentDataContainer.set(this.projectileNameSpacedKey, PersistentDataType.STRING, (Object)key);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public ItemStack getItemStackFromProjectile(Projectile projectile) {
        ProjectileData projectileData = this.getDataFromProjectile(projectile);
        if (projectileData == null) {
            return null;
        }
        String key = this.getKeyFromProjectile(projectile);
        if (key == null) {
            return null;
        }
        ItemStack itemStack = this.getItemStackFromKey(key);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        PersistentDataContainer persistentDataContainer = itemMeta.getPersistentDataContainer();
        persistentDataContainer.set(this.projectileNameSpacedKey, PersistentDataType.STRING, (Object)key);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public String getKeyFromProjectile(Projectile projectile) {
        PersistentDataContainer persistentDataContainer = projectile.getPersistentDataContainer();
        return (String)persistentDataContainer.get(this.projectileNameSpacedKey, PersistentDataType.STRING);
    }

    @Override
    public ProjectileData getDataFromProjectile(Projectile projectile) {
        String key = this.getKeyFromProjectile(projectile);
        if (key == null) {
            return null;
        }
        return this.projectileDataMap.get(key);
    }

    @Override
    public void removeProjectile(Projectile projectile) {
        this.projectileMap.remove(projectile);
    }

    @Override
    public void addProjectile(String key, Projectile projectile) {
        this.projectileMap.put(projectile, key);
    }

    @Override
    public void addProjectile(String key, ProjectileData projectileData) {
        this.projectileDataMap.put(key, projectileData);
    }

    @Override
    public void removeProjectile(String key) {
        this.projectileDataMap.remove(key);
    }

    @Override
    public boolean containKey(String key) {
        return this.projectileDataMap.containsKey(key);
    }

    @Override
    public boolean hasProjectileData(Entity entity) {
        return entity.getPersistentDataContainer().has(this.projectileNameSpacedKey, PersistentDataType.STRING);
    }

    @Override
    public ProjectileData getDataFromKey(String key) {
        return this.projectileDataMap.get(key);
    }

    @Override
    public Map<Projectile, String> getProjectileMap() {
        return Collections.unmodifiableMap(this.projectileMap);
    }

    @Override
    public Map<String, ProjectileData> getProjectileDataMap() {
        return this.projectileDataMap;
    }
}

