/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.bouncyball.services.implementations;

import com.google.common.reflect.TypeToken;
import com.huskydreaming.bouncyball.BouncyBallPlugin;
import com.huskydreaming.bouncyball.data.ParticleData;
import com.huskydreaming.bouncyball.data.ProjectileDefault;
import com.huskydreaming.bouncyball.services.interfaces.ParticleService;
import com.huskydreaming.bouncyball.services.interfaces.ProjectileService;
import com.huskydreaming.bouncyball.storage.base.Json;
import com.huskydreaming.bouncyball.utilities.Util;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class ParticleServiceImpl
implements ParticleService {
    private Map<String, ParticleData> particleDataMap = new HashMap<String, ParticleData>();
    private final ProjectileService projectileService;

    @Override
    public void deserialize(BouncyBallPlugin plugin) {
        Type type = new TypeToken<Map<String, ParticleData>>(){}.getType();
        this.particleDataMap = (Map)Json.read((Plugin)plugin, "data/particles", type);
        if (this.particleDataMap != null) {
            return;
        }
        this.particleDataMap = new ConcurrentHashMap<String, ParticleData>();
        for (ProjectileDefault projectileDefault : ProjectileDefault.values()) {
            if (projectileDefault == ProjectileDefault.DEFAULT) continue;
            CharSequence[] strings = projectileDefault.name().toLowerCase().split("_");
            String string = Util.capitalize(String.join((CharSequence)"_", strings));
            this.particleDataMap.put(string, projectileDefault.getParticleData());
        }
    }

    @Override
    public void serialize(BouncyBallPlugin plugin) {
        Json.write((Plugin)plugin, "data/particles", this.particleDataMap);
    }

    public ParticleServiceImpl(BouncyBallPlugin plugin) {
        this.projectileService = plugin.provide(ProjectileService.class);
    }

    @Override
    public void addParticle(String key, ParticleData particleData) {
        this.particleDataMap.put(key, particleData);
    }

    @Override
    public ParticleData getParticle(String key) {
        return this.particleDataMap.get(key);
    }

    @Override
    public void run(BouncyBallPlugin plugin) {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, () -> this.projectileService.getProjectileMap().forEach((projectile, s) -> {
            Location location = projectile.getLocation();
            World world = location.getWorld();
            if (world == null) {
                return;
            }
            ParticleData particleData = this.particleDataMap.get(s);
            if (particleData == null) {
                return;
            }
            if (particleData.getParticle() == Particle.REDSTONE) {
                Particle.DustOptions dustOptions = new Particle.DustOptions(particleData.getColor(), 1.0f);
                world.spawnParticle(particleData.getParticle(), location, particleData.getCount(), (Object)dustOptions);
            } else {
                world.spawnParticle(particleData.getParticle(), location, particleData.getCount());
            }
        }), 0L, 1L);
    }
}

