/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.bouncyball.registries;

import com.huskydreaming.bouncyball.BouncyBallPlugin;
import com.huskydreaming.bouncyball.commands.base.CommandExecutor;
import com.huskydreaming.bouncyball.commands.base.CommandInterface;
import com.huskydreaming.bouncyball.commands.subcommands.CreateCommand;
import com.huskydreaming.bouncyball.commands.subcommands.GiveCommand;
import com.huskydreaming.bouncyball.commands.subcommands.ReloadCommand;
import com.huskydreaming.bouncyball.registries.Registry;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;

public class CommandRegistry
implements Registry {
    private final Set<CommandInterface> commands = new HashSet<CommandInterface>();

    public Set<CommandInterface> getCommands() {
        return Collections.unmodifiableSet(this.commands);
    }

    @Override
    public void register(BouncyBallPlugin plugin) {
        CommandExecutor commandExecutor = new CommandExecutor(plugin);
        this.commands.add(new CreateCommand(plugin));
        this.commands.add(new GiveCommand(plugin));
        this.commands.add(new ReloadCommand(plugin));
        try {
            Server server = Bukkit.getServer();
            Field field = server.getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            CommandMap commandMap = (CommandMap)field.get(server);
            commandMap.register("bouncyballs", (Command)commandExecutor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

