/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.bouncyball.listeners;

import com.huskydreaming.bouncyball.BouncyBallPlugin;
import com.huskydreaming.bouncyball.data.ProjectileData;
import com.huskydreaming.bouncyball.data.ProjectileSetting;
import com.huskydreaming.bouncyball.services.interfaces.ProjectileService;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ProjectileListener
implements Listener {
    private final Plugin plugin;
    private final ProjectileService projectileService;

    public ProjectileListener(BouncyBallPlugin plugin) {
        this.plugin = plugin;
        this.projectileService = plugin.provide(ProjectileService.class);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR) {
            ItemStack itemStack = event.getItem();
            if (itemStack == null) {
                return;
            }
            String key = this.projectileService.getKeyFromItemStack(itemStack);
            if (key != null) {
                this.projectileService.launchProjectile(this.plugin, event.getPlayer(), itemStack, key);
                event.setCancelled(true);
            } else {
                event.setCancelled(false);
            }
        } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ItemStack itemStack = event.getItem();
            if (itemStack == null) {
                return;
            }
            String key = this.projectileService.getKeyFromItemStack(itemStack);
            if (key != null) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBlockEvent(BlockIgniteEvent event) {
        Entity entity;
        if (event.getCause() == BlockIgniteEvent.IgniteCause.FIREBALL && (entity = event.getIgnitingEntity()) != null && this.projectileService.hasProjectileData(entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        if (projectile instanceof Snowball) {
            Snowball snowball = (Snowball)projectile;
            ProjectileData projectileData = this.projectileService.getDataFromProjectile((Projectile)snowball);
            if (projectileData == null) {
                return;
            }
            Entity entity = event.getHitEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (projectileData.getSettings().contains((Object)ProjectileSetting.RETURNS)) {
                    ItemStack itemStack = this.projectileService.getItemStackFromProjectile((Projectile)snowball);
                    if (itemStack == null) {
                        return;
                    }
                    player.getInventory().addItem(new ItemStack[]{itemStack});
                    this.projectileService.removeProjectile((Projectile)snowball);
                    snowball.remove();
                    return;
                }
            }
            if (projectileData.isBouncyBlock(event.getHitBlock())) {
                String key = this.projectileService.getKeyFromProjectile((Projectile)snowball);
                Projectile projectile2 = this.projectileService.updateProjectile(this.plugin, (Projectile)snowball);
                if (projectile2 != null) {
                    this.projectileService.addProjectile(key, projectile2);
                }
                this.projectileService.removeProjectile((Projectile)snowball);
                snowball.remove();
                return;
            }
            this.projectileService.dropProjectile((Projectile)snowball);
            this.projectileService.removeProjectile((Projectile)snowball);
            snowball.remove();
        }
    }
}

