/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.bouncyball.inventories.providers;

import com.huskydreaming.bouncyball.BouncyBallPlugin;
import com.huskydreaming.bouncyball.data.ProjectileData;
import com.huskydreaming.bouncyball.data.ProjectilePhysics;
import com.huskydreaming.bouncyball.data.ProjectileSetting;
import com.huskydreaming.bouncyball.inventories.base.InventoryItem;
import com.huskydreaming.bouncyball.services.interfaces.InventoryService;
import com.huskydreaming.bouncyball.services.interfaces.ProjectileService;
import com.huskydreaming.bouncyball.storage.enumeration.Menu;
import com.huskydreaming.bouncyball.utilities.ItemBuilder;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EditInventory
implements InventoryProvider {
    private final String key;
    private final BouncyBallPlugin plugin;
    private final InventoryService inventoryService;
    private final ProjectileService projectileService;

    public EditInventory(BouncyBallPlugin plugin, String key) {
        this.key = key;
        this.plugin = plugin;
        this.inventoryService = plugin.provide(InventoryService.class);
        this.projectileService = plugin.provide(ProjectileService.class);
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(InventoryItem.border());
        contents.set(0, 0, InventoryItem.back(player, this.inventoryService.getBouncyBallsInventory(this.plugin)));
        contents.set(0, 1, this.deleteItem());
        contents.set(1, 2, this.editMaterials());
        contents.set(1, 3, this.editParticles());
        int physicsIndex = 4;
        for (ProjectilePhysics projectilePhysics : ProjectilePhysics.values()) {
            contents.set(1, physicsIndex++, this.physicsItem(projectilePhysics, contents));
        }
        int settingsIndex = 2;
        for (ProjectileSetting projectileSetting : ProjectileSetting.values()) {
            contents.set(2, settingsIndex++, this.activeItem(projectileSetting, contents));
        }
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }

    private ClickableItem editMaterials() {
        ItemStack itemStack = ItemBuilder.create().setDisplayName(Menu.EDIT_MATERIAL_TITLE.parse()).setLore(Menu.EDIT_MATERIAL_LORE.parseList()).setMaterial(Material.ANVIL).build();
        return ClickableItem.of(itemStack, e -> {
            HumanEntity patt2832$temp = e.getWhoClicked();
            if (patt2832$temp instanceof Player) {
                Player player = (Player)patt2832$temp;
                this.inventoryService.getMaterialInventory(player.getWorld(), this.plugin, this.key).open(player);
            }
        });
    }

    private ClickableItem deleteItem() {
        ItemStack itemStack = ItemBuilder.create().setDisplayName(Menu.EDIT_DELETE_TITLE.parse()).setLore(Menu.EDIT_DELETE_LORE.parseList()).setMaterial(Material.TNT_MINECART).build();
        return ClickableItem.of(itemStack, e -> {
            HumanEntity patt3386$temp = e.getWhoClicked();
            if (patt3386$temp instanceof Player) {
                Player player = (Player)patt3386$temp;
                this.projectileService.removeProjectile(this.key);
                if (this.projectileService.getProjectileDataMap().isEmpty()) {
                    player.closeInventory();
                } else {
                    this.inventoryService.getBouncyBallsInventory(this.plugin).open(player);
                }
            }
        });
    }

    private ClickableItem editParticles() {
        ItemStack itemStack = ItemBuilder.create().setDisplayName(Menu.EDIT_PARTICLE_TITLE.parse()).setLore(Menu.EDIT_PARTICLE_LORE.parseList()).setMaterial(Material.NETHER_STAR).build();
        return ClickableItem.of(itemStack, e -> {
            HumanEntity patt4156$temp = e.getWhoClicked();
            if (patt4156$temp instanceof Player) {
                Player player = (Player)patt4156$temp;
                this.inventoryService.getParticleInventory(this.plugin, this.key).open(player);
            }
        });
    }

    private ClickableItem activeItem(ProjectileSetting projectileSetting, InventoryContents contents) {
        String materialEnabled = Menu.GENERAL_ENABLE_MATERIAL.parse();
        String materialDisabled = Menu.GENERAL_DISABLED_MATERIAL.parse();
        String displayNameEnabled = Menu.GENERAL_ENABLE_TITLE.parameterize(projectileSetting.name());
        String displayNameDisabled = Menu.GENERAL_DISABLED_TITLE.parameterize(projectileSetting.name());
        ProjectileData projectileData = this.projectileService.getDataFromKey(this.key);
        Set<ProjectileSetting> settings = projectileData.getSettings();
        boolean enabled = settings.contains((Object)projectileSetting);
        String displayName = enabled ? displayNameEnabled : displayNameDisabled;
        Material material = Material.valueOf((String)(enabled ? materialEnabled : materialDisabled));
        String description = enabled ? Menu.GENERAL_ENABLED_DESCRIPTION.parse() : Menu.GENERAL_DISABLED_DESCRIPTION.parse();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(Menu.GENERAL_DESCRIPTION.parameterize(projectileSetting.getDescription()));
        strings.add("");
        strings.add(description);
        ItemStack itemStack = ItemBuilder.create().setDisplayName(displayName).setLore(strings).setMaterial(material).build();
        return ClickableItem.of(itemStack, e -> {
            HumanEntity patt5792$temp = e.getWhoClicked();
            if (patt5792$temp instanceof Player) {
                Player player = (Player)patt5792$temp;
                if (settings.contains((Object)projectileSetting)) {
                    projectileData.removeSetting(projectileSetting);
                } else {
                    projectileData.addSetting(projectileSetting);
                }
                contents.inventory().open(player);
            }
        });
    }

    private ClickableItem physicsItem(ProjectilePhysics projectilePhysics, InventoryContents contents) {
        ProjectileData projectileData = this.projectileService.getDataFromKey(this.key);
        double amount = projectileData.getPhysics(projectilePhysics);
        ItemStack itemStack = ItemBuilder.create().setDisplayName(Menu.EDIT_PHYSICS_TITLE.parameterize(projectilePhysics.name())).setLore(Menu.EDIT_PHYSICS_LORE.parameterizeList(projectilePhysics.getDescription(), amount)).setMaterial(projectilePhysics.getMaterial()).build();
        return ClickableItem.of(itemStack, e -> {
            HumanEntity patt6849$temp = e.getWhoClicked();
            if (patt6849$temp instanceof Player) {
                Player player = (Player)patt6849$temp;
                double increment = projectilePhysics.getIncrement();
                DecimalFormat df = new DecimalFormat("0.00");
                if (e.isLeftClick()) {
                    projectileData.setPhysics(projectilePhysics, Double.parseDouble(df.format(amount + increment)));
                    contents.inventory().open(player);
                    return;
                }
                if (e.isRightClick()) {
                    if (amount <= increment) {
                        projectileData.setPhysics(projectilePhysics, increment);
                        contents.inventory().open(player);
                        return;
                    }
                    projectileData.setPhysics(projectilePhysics, Double.parseDouble(df.format(amount - increment)));
                    contents.inventory().open(player);
                }
            }
        });
    }
}

