/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.bouncyball.inventories.base;

import com.huskydreaming.bouncyball.inventories.base.InventoryItem;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import fr.minuskube.inv.content.Pagination;
import fr.minuskube.inv.content.SlotIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class InventoryPageProvider<E>
implements InventoryProvider {
    protected SmartInventory smartInventory;
    protected final int rows;
    protected E[] array;

    public InventoryPageProvider(int rows, E[] array) {
        this.rows = rows;
        this.array = array;
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(InventoryItem.border());
        if (this.smartInventory != null) {
            contents.set(0, 0, InventoryItem.back(player, this.smartInventory));
        }
        ClickableItem[] clickableItems = new ClickableItem[this.array.length];
        for (int i = 0; i < clickableItems.length; ++i) {
            AtomicInteger atomicInteger = new AtomicInteger(i);
            ItemStack itemStack = this.construct(player, i + 1, this.array[atomicInteger.get()]);
            Consumer<InventoryClickEvent> consumer = e -> this.run((InventoryClickEvent)e, this.array[atomicInteger.get()], contents);
            clickableItems[i] = ClickableItem.of(itemStack, consumer);
        }
        this.setupPagination(player, contents, clickableItems);
    }

    @Override
    public void update(Player player, InventoryContents inventoryContents) {
    }

    public abstract ItemStack construct(Player var1, int var2, E var3);

    public abstract void run(InventoryClickEvent var1, E var2, InventoryContents var3);

    private void setupPagination(Player player, InventoryContents contents, ClickableItem[] clickableItems) {
        Pagination pagination = contents.pagination();
        pagination.setItems(clickableItems);
        pagination.setItemsPerPage(Math.min(this.rows * 9, 27));
        pagination.addToIterator(contents.newIterator(SlotIterator.Type.HORIZONTAL, 1, 0));
        if (!pagination.isLast() && !pagination.isFirst()) {
            contents.set(4, 1, InventoryItem.previous(player, contents));
            contents.set(4, 7, InventoryItem.next(player, contents));
        }
        if (!pagination.isLast()) {
            contents.set(4, 7, InventoryItem.next(player, contents));
        }
        if (!pagination.isFirst()) {
            contents.set(4, 1, InventoryItem.previous(player, contents));
        }
    }
}

