/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.bouncyball.data;

import com.huskydreaming.bouncyball.data.ProjectilePhysics;
import com.huskydreaming.bouncyball.data.ProjectileSetting;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.block.Block;

public final class ProjectileData {
    private final Set<Material> blocks = new HashSet<Material>();
    private final Set<ProjectileSetting> settings = new HashSet<ProjectileSetting>();
    private final Map<ProjectilePhysics, Double> physics = new ConcurrentHashMap<ProjectilePhysics, Double>();
    private Material material;

    public boolean isBouncyBlock(Block block) {
        if (!this.blocks.isEmpty() && block != null) {
            return this.blocks.contains(block.getType());
        }
        return true;
    }

    public void addBlock(Material material) {
        this.blocks.add(material);
    }

    public void removeBlock(Material material) {
        this.blocks.remove(material);
    }

    public Set<Material> getBlocks() {
        return Collections.unmodifiableSet(this.blocks);
    }

    public void addSetting(ProjectileSetting setting) {
        this.settings.add(setting);
    }

    public void removeSetting(ProjectileSetting setting) {
        this.settings.remove((Object)setting);
    }

    public Set<ProjectileSetting> getSettings() {
        return Collections.unmodifiableSet(this.settings);
    }

    public void setPhysics(ProjectilePhysics projectilePhysics, double amount) {
        this.physics.put(projectilePhysics, amount);
    }

    public double getPhysics(ProjectilePhysics projectilePhysics) {
        return this.physics.get((Object)projectilePhysics);
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public Material getMaterial() {
        return this.material;
    }
}

