/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.bouncyball.commands.subcommands;

import com.huskydreaming.bouncyball.BouncyBallPlugin;
import com.huskydreaming.bouncyball.commands.base.Command;
import com.huskydreaming.bouncyball.commands.base.CommandInterface;
import com.huskydreaming.bouncyball.commands.base.CommandLabel;
import com.huskydreaming.bouncyball.services.interfaces.LocaleService;
import com.huskydreaming.bouncyball.services.interfaces.ParticleService;
import com.huskydreaming.bouncyball.services.interfaces.ProjectileService;
import com.huskydreaming.bouncyball.storage.enumeration.Locale;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@Command(label=CommandLabel.RELOAD)
public class ReloadCommand
implements CommandInterface {
    private final BouncyBallPlugin plugin;
    private final LocaleService localeService;
    private final ParticleService particleService;
    private final ProjectileService projectileService;

    public ReloadCommand(BouncyBallPlugin plugin) {
        this.plugin = plugin;
        this.localeService = plugin.provide(LocaleService.class);
        this.particleService = plugin.provide(ParticleService.class);
        this.projectileService = plugin.provide(ProjectileService.class);
    }

    @Override
    public void run(Player player, String[] strings) {
        this.localeService.getLocale().reload((Plugin)this.plugin);
        this.localeService.getMenu().reload((Plugin)this.plugin);
        this.particleService.serialize(this.plugin);
        this.projectileService.serialize(this.plugin);
        player.sendMessage(Locale.RELOAD.prefix(new Object[0]));
    }

    @Override
    public List<String> onTabComplete(String[] strings) {
        return List.of();
    }
}

