/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.bouncyball;

import com.huskydreaming.bouncyball.registries.CommandRegistry;
import com.huskydreaming.bouncyball.registries.ListenerRegistry;
import com.huskydreaming.bouncyball.registries.Registry;
import com.huskydreaming.bouncyball.registries.ServiceRegistry;
import com.huskydreaming.bouncyball.services.interfaces.ParticleService;
import java.util.Arrays;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BouncyBallPlugin
extends JavaPlugin {
    private ServiceRegistry serviceRegistry;
    private CommandRegistry commandRegistry;

    public void onEnable() {
        this.serviceRegistry = new ServiceRegistry();
        this.commandRegistry = new CommandRegistry();
        ListenerRegistry listenerRegistry = new ListenerRegistry();
        this.register(this.serviceRegistry, this.commandRegistry, listenerRegistry);
        this.provide(ParticleService.class).run(this);
    }

    public void onDisable() {
        this.serviceRegistry.unregister(this);
    }

    @NotNull
    public <T> T provide(Class<T> tClass) {
        return tClass.cast(this.serviceRegistry.getServices().get(tClass));
    }

    private void register(Registry ... registries) {
        Arrays.stream(registries).forEach(registry -> registry.register(this));
    }

    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }
}

