/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.replacer;

import java.util.function.Function;
import java.util.regex.Pattern;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.replacer.Replacer;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExactReplacer
implements Replacer {
    private static final Pattern DELIMITER = Pattern.compile("_");
    private final char start;
    private final char end;

    public ExactReplacer(char start, char end) {
        this.start = start;
        this.end = end;
    }

    @Override
    @NotNull
    public String apply(@NotNull String text, @Nullable OfflinePlayer player, @NotNull Function<String, @Nullable PlaceholderExpansion> lookup) {
        String[] parts = DELIMITER.split(text = text.substring(1, text.length() - 1));
        PlaceholderExpansion expansion = parts.length == 0 ? lookup.apply(text) : lookup.apply(parts[0]);
        if (expansion == null) {
            return this.start + text + this.end;
        }
        String params = text.endsWith("_") ? "" : text.substring(text.indexOf(95) + 1);
        String result = expansion.onRequest(player, params);
        if (result == null) {
            return this.start + text + this.end;
        }
        return result;
    }
}

