/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.replacer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;

public class ComponentReplacer {
    @NotNull
    public static Component replace(@NotNull Component component, @NotNull Function<String, String> replacer) {
        return ComponentReplacer.rebuild(component, replacer);
    }

    @NotNull
    private static Component rebuild(@NotNull Component component, @NotNull Function<String, String> replacer) {
        TextComponent rebuilt;
        if (component instanceof TextComponent) {
            TextComponent text = (TextComponent)component;
            String replaced = replacer.apply(text.content());
            rebuilt = Component.text((String)replaced);
        } else if (component instanceof TranslatableComponent) {
            TranslatableComponent translatable = (TranslatableComponent)component;
            ArrayList<Component> arguments = new ArrayList<Component>();
            for (ComponentLike arg : translatable.arguments()) {
                arguments.add(ComponentReplacer.rebuild(arg.asComponent(), replacer));
            }
            rebuilt = Component.translatable((String)translatable.key(), arguments);
        } else if (component instanceof KeybindComponent) {
            KeybindComponent keybind = (KeybindComponent)component;
            rebuilt = Component.keybind((String)keybind.keybind());
        } else if (component instanceof ScoreComponent) {
            ScoreComponent score = (ScoreComponent)component;
            rebuilt = Component.score((String)score.name(), (String)score.objective());
        } else if (component instanceof SelectorComponent) {
            SelectorComponent selector = (SelectorComponent)component;
            rebuilt = Component.selector((String)selector.pattern());
        } else {
            rebuilt = Component.empty();
        }
        rebuilt = rebuilt.style(ComponentReplacer.rebuildStyle(component.style(), replacer));
        if (!component.children().isEmpty()) {
            ArrayList<Component> children = new ArrayList<Component>();
            for (Component child : component.children()) {
                children.add(ComponentReplacer.rebuild(child, replacer));
            }
            rebuilt = rebuilt.children(children);
        }
        return rebuilt;
    }

    @NotNull
    private static Style rebuildStyle(@NotNull Style style, @NotNull Function<String, String> replacer) {
        HoverEvent hover;
        Style.Builder builder = style.toBuilder();
        ClickEvent click = style.clickEvent();
        if (click != null) {
            builder.clickEvent(ComponentReplacer.rebuildClickEvent(click, replacer));
        }
        if ((hover = style.hoverEvent()) != null) {
            builder.hoverEvent(ComponentReplacer.rebuildHoverEvent(hover, replacer));
        }
        return builder.build();
    }

    @NotNull
    private static ClickEvent rebuildClickEvent(@NotNull ClickEvent click, @NotNull Function<String, String> replacer) {
        ClickEvent.Payload payload = click.payload();
        if (!(payload instanceof ClickEvent.Payload.Text)) {
            return click;
        }
        String original = ((ClickEvent.Payload.Text)payload).value();
        String replaced = replacer.apply(original);
        ClickEvent.Action action = click.action();
        switch (action) {
            case OPEN_URL: {
                return ClickEvent.openUrl((String)replaced);
            }
            case OPEN_FILE: {
                return ClickEvent.openFile((String)replaced);
            }
            case RUN_COMMAND: {
                return ClickEvent.runCommand((String)replaced);
            }
            case SUGGEST_COMMAND: {
                return ClickEvent.suggestCommand((String)replaced);
            }
            case COPY_TO_CLIPBOARD: {
                return ClickEvent.copyToClipboard((String)replaced);
            }
        }
        return click;
    }

    @NotNull
    private static HoverEvent<?> rebuildHoverEvent(@NotNull HoverEvent<?> hover, @NotNull Function<String, String> replacer) {
        Object value = hover.value();
        if (value instanceof Component) {
            Component rebuilt = ComponentReplacer.rebuild((Component)value, replacer);
            return HoverEvent.showText((Component)rebuilt);
        }
        if (value instanceof HoverEvent.ShowItem) {
            return ComponentReplacer.rebuildShowItem((HoverEvent.ShowItem)value, replacer);
        }
        if (value instanceof HoverEvent.ShowEntity) {
            HoverEvent.ShowEntity entity = (HoverEvent.ShowEntity)value;
            Component rebuiltName = null;
            if (entity.name() != null) {
                rebuiltName = ComponentReplacer.rebuild(entity.name(), replacer);
            }
            return HoverEvent.showEntity((Key)entity.type(), (UUID)entity.id(), (Component)rebuiltName);
        }
        return hover;
    }

    @NotNull
    private static HoverEvent<?> rebuildShowItem(@NotNull HoverEvent.ShowItem item, @NotNull Function<String, String> replacer) {
        BinaryTagHolder nbt = item.nbt();
        if (nbt != null && !nbt.string().isEmpty()) {
            String replaced = replacer.apply(nbt.string());
            return HoverEvent.showItem((Key)item.item(), (int)item.count(), (BinaryTagHolder)BinaryTagHolder.binaryTagHolder((String)replaced));
        }
        Map components = item.dataComponents();
        if (!components.isEmpty()) {
            HashMap<Key, Object> rebuilt = new HashMap<Key, Object>();
            for (Map.Entry entry : components.entrySet()) {
                DataComponentValue value = (DataComponentValue)entry.getValue();
                if (!(value instanceof BinaryTagHolder)) {
                    rebuilt.put((Key)entry.getKey(), value);
                    continue;
                }
                rebuilt.put((Key)entry.getKey(), BinaryTagHolder.binaryTagHolder((String)replacer.apply(((BinaryTagHolder)value).string())));
            }
            return HoverEvent.showItem((Keyed)item.item(), (int)item.count(), rebuilt);
        }
        return HoverEvent.showItem((HoverEvent.ShowItem)item);
    }
}

