/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.libs.kyori.adventure.platform.bukkit;

import java.util.Collection;
import me.clip.placeholderapi.libs.kyori.adventure.platform.bukkit.CraftBukkitFacet;
import me.clip.placeholderapi.libs.kyori.adventure.platform.bukkit.MinecraftReflection;
import me.clip.placeholderapi.libs.kyori.adventure.platform.bukkit.SpigotFacet;
import me.clip.placeholderapi.libs.kyori.adventure.platform.facet.Facet;
import me.clip.placeholderapi.libs.kyori.adventure.platform.facet.FacetComponentFlattener;
import me.clip.placeholderapi.libs.kyori.adventure.text.flattener.ComponentFlattener;
import me.clip.placeholderapi.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import me.clip.placeholderapi.libs.kyori.adventure.text.serializer.json.JSONOptions;
import me.clip.placeholderapi.libs.kyori.adventure.text.serializer.json.legacyimpl.NBTLegacyHoverEventSerializer;
import me.clip.placeholderapi.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;

public final class BukkitComponentSerializer {
    private static final boolean IS_1_13 = MinecraftReflection.findEnum(Material.class, "BLUE_ICE") != null;
    private static final boolean IS_1_16 = MinecraftReflection.findEnum(Material.class, "NETHERITE_PICKAXE") != null;
    private static final Collection<FacetComponentFlattener.Translator<Server>> TRANSLATORS = Facet.of(SpigotFacet.Translator::new, CraftBukkitFacet.Translator::new);
    private static final LegacyComponentSerializer LEGACY_SERIALIZER;
    private static final GsonComponentSerializer GSON_SERIALIZER;
    static final ComponentFlattener FLATTENER;

    private BukkitComponentSerializer() {
    }

    @NotNull
    public static LegacyComponentSerializer legacy() {
        return LEGACY_SERIALIZER;
    }

    @NotNull
    public static GsonComponentSerializer gson() {
        return GSON_SERIALIZER;
    }

    static {
        FLATTENER = FacetComponentFlattener.get(Bukkit.getServer(), TRANSLATORS);
        GSON_SERIALIZER = IS_1_13 ? GsonComponentSerializer.builder().options(JSONOptions.byDataVersion().at(Bukkit.getUnsafe().getDataVersion())).build() : GsonComponentSerializer.builder().legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).options(JSONOptions.byDataVersion().at(0)).build();
        LEGACY_SERIALIZER = IS_1_16 ? LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().flattener(FLATTENER).build() : LegacyComponentSerializer.builder().character('\u00a7').flattener(FLATTENER).build();
    }
}

