/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi;

import java.util.List;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.replacer.ComponentReplacer;
import me.clip.placeholderapi.replacer.ExactReplacer;
import me.clip.placeholderapi.replacer.RelationalExactReplacer;
import me.clip.placeholderapi.replacer.Replacer;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class PAPIComponents {
    private static final Replacer PERCENT_EXACT_REPLACER = new ExactReplacer('%', '%');
    private static final Replacer BRACKET_EXACT_REPLACER = new ExactReplacer('{', '}');
    private static final RelationalExactReplacer RELATIONAL_EXACT_REPLACER = new RelationalExactReplacer();

    @NotNull
    public static Component setPlaceholders(OfflinePlayer player, @NotNull Component component) {
        if (PlaceholderAPIPlugin.getInstance().getPlaceholderAPIConfig().useAdventureProvidedReplacer()) {
            return component.replaceText(config -> config.match(PlaceholderAPI.PLACEHOLDER_PATTERN).replacement((result, builder) -> builder.content(PERCENT_EXACT_REPLACER.apply(result.group(), player, PlaceholderAPIPlugin.getInstance().getLocalExpansionManager()::getExpansion))));
        }
        return ComponentReplacer.replace(component, str -> PlaceholderAPI.setPlaceholders(player, str));
    }

    @NotNull
    public static List<Component> setPlaceholders(OfflinePlayer player, @NotNull List<Component> components) {
        return components.stream().map(component -> PAPIComponents.setPlaceholders(player, component)).collect(Collectors.toList());
    }

    @NotNull
    public static Component setPlaceholders(Player player, @NotNull Component component) {
        return PAPIComponents.setPlaceholders((OfflinePlayer)player, component);
    }

    @NotNull
    public static List<Component> setPlaceholders(Player player, @NotNull List<Component> components) {
        return PAPIComponents.setPlaceholders((OfflinePlayer)player, components);
    }

    @NotNull
    public static Component setBracketPlaceholders(OfflinePlayer player, @NotNull Component component) {
        if (PlaceholderAPIPlugin.getInstance().getPlaceholderAPIConfig().useAdventureReplacer()) {
            return component.replaceText(config -> config.match(PlaceholderAPI.BRACKET_PLACEHOLDER_PATTERN).replacement((result, builder) -> builder.content(BRACKET_EXACT_REPLACER.apply(result.group(), player, PlaceholderAPIPlugin.getInstance().getLocalExpansionManager()::getExpansion))));
        }
        return ComponentReplacer.replace(component, str -> PlaceholderAPI.setBracketPlaceholders(player, str));
    }

    @NotNull
    public static List<Component> setBracketPlaceholders(OfflinePlayer player, @NotNull List<Component> components) {
        return components.stream().map(component -> PAPIComponents.setBracketPlaceholders(player, component)).collect(Collectors.toList());
    }

    @NotNull
    public static Component setBracketPlaceholders(Player player, @NotNull Component component) {
        return PAPIComponents.setBracketPlaceholders((OfflinePlayer)player, component);
    }

    @NotNull
    public static List<Component> setBracketPlaceholders(Player player, @NotNull List<Component> components) {
        return PAPIComponents.setBracketPlaceholders((OfflinePlayer)player, components);
    }

    public static Component setRelationalPlaceholders(Player one, Player two, Component component) {
        return component.replaceText(config -> config.match(PlaceholderAPI.RELATIONAL_PLACEHOLDER_PATTERN).replacement((result, builder) -> builder.content(RELATIONAL_EXACT_REPLACER.apply(result.group(2), one, two, PlaceholderAPIPlugin.getInstance().getLocalExpansionManager()::getExpansion))));
    }

    public static List<Component> setRelationalPlaceholders(Player one, Player two, List<Component> components) {
        return components.stream().map(line -> PAPIComponents.setRelationalPlaceholders(one, two, line)).collect(Collectors.toList());
    }
}

