/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.replacer;

import java.util.Locale;
import java.util.function.Function;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.replacer.Replacer;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharsReplacer
implements Replacer {
    @NotNull
    private final Replacer.Closure closure;

    public CharsReplacer(@NotNull Replacer.Closure closure) {
        this.closure = closure;
    }

    @Override
    @NotNull
    public String apply(@NotNull String text, @Nullable OfflinePlayer player, @NotNull Function<String, @Nullable PlaceholderExpansion> lookup) {
        char[] chars = text.toCharArray();
        StringBuilder builder = new StringBuilder(text.length());
        StringBuilder identifier = new StringBuilder();
        StringBuilder parameters = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char l = chars[i];
            if (l != this.closure.head || i + 1 >= chars.length) {
                builder.append(l);
                continue;
            }
            boolean identified = false;
            boolean invalid = true;
            boolean hadSpace = false;
            while (++i < chars.length) {
                char p = chars[i];
                if (p == ' ' && !identified) {
                    hadSpace = true;
                    break;
                }
                if (p == this.closure.tail) {
                    invalid = false;
                    break;
                }
                if (p == '_' && !identified) {
                    identified = true;
                    continue;
                }
                if (identified) {
                    parameters.append(p);
                    continue;
                }
                identifier.append(p);
            }
            String identifierString = identifier.toString();
            String lowercaseIdentifierString = identifierString.toLowerCase(Locale.ROOT);
            String parametersString = parameters.toString();
            identifier.setLength(0);
            parameters.setLength(0);
            if (invalid) {
                builder.append(this.closure.head).append(identifierString);
                if (identified) {
                    builder.append('_').append(parametersString);
                }
                if (!hadSpace) continue;
                builder.append(' ');
                continue;
            }
            PlaceholderExpansion placeholder = lookup.apply(lowercaseIdentifierString);
            if (placeholder == null) {
                builder.append(this.closure.head).append(identifierString);
                if (identified) {
                    builder.append('_');
                }
                builder.append(parametersString).append(this.closure.tail);
                continue;
            }
            String replacement = placeholder.onRequest(player, parametersString);
            if (replacement == null) {
                builder.append(this.closure.head).append(identifierString);
                if (identified) {
                    builder.append('_');
                }
                builder.append(parametersString).append(this.closure.tail);
                continue;
            }
            builder.append(replacement);
        }
        return builder.toString();
    }
}

