/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.expansion.manager;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.events.ExpansionRegisterEvent;
import me.clip.placeholderapi.events.ExpansionUnregisterEvent;
import me.clip.placeholderapi.events.ExpansionsLoadedEvent;
import me.clip.placeholderapi.expansion.Cacheable;
import me.clip.placeholderapi.expansion.Cleanable;
import me.clip.placeholderapi.expansion.Configurable;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Taskable;
import me.clip.placeholderapi.expansion.VersionSpecific;
import me.clip.placeholderapi.expansion.cloud.CloudExpansion;
import me.clip.placeholderapi.expansion.manager.MethodSignature;
import me.clip.placeholderapi.util.FileUtil;
import me.clip.placeholderapi.util.Futures;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class LocalExpansionManager
implements Listener {
    @NotNull
    private static final String EXPANSIONS_FOLDER_NAME = "expansions";
    @NotNull
    private static final Set<MethodSignature> ABSTRACT_EXPANSION_METHODS = Arrays.stream(PlaceholderExpansion.class.getDeclaredMethods()).filter(method -> Modifier.isAbstract(method.getModifiers())).map(method -> new MethodSignature(method.getName(), method.getParameterTypes())).collect(Collectors.toSet());
    @NotNull
    private final File folder;
    @NotNull
    private final PlaceholderAPIPlugin plugin;
    @NotNull
    private final Map<String, PlaceholderExpansion> expansions = new ConcurrentHashMap<String, PlaceholderExpansion>();
    private final ReentrantLock expansionsLock = new ReentrantLock();

    public LocalExpansionManager(@NotNull PlaceholderAPIPlugin plugin) {
        this.plugin = plugin;
        this.folder = new File(plugin.getDataFolder(), EXPANSIONS_FOLDER_NAME);
        if (!this.folder.exists() && !this.folder.mkdirs()) {
            Msg.warn("Failed to create expansions folder!", new Object[0]);
        }
    }

    public void load(@NotNull CommandSender sender) {
        this.registerAll(sender);
    }

    public void kill() {
        this.unregisterAll();
    }

    @NotNull
    public File getExpansionsFolder() {
        return this.folder;
    }

    @NotNull
    public @Unmodifiable Collection<String> getIdentifiers() {
        this.expansionsLock.lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.expansions.keySet());
            return immutableSet;
        }
        finally {
            this.expansionsLock.unlock();
        }
    }

    @NotNull
    public @Unmodifiable Collection<PlaceholderExpansion> getExpansions() {
        this.expansionsLock.lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.expansions.values());
            return immutableSet;
        }
        finally {
            this.expansionsLock.unlock();
        }
    }

    @Nullable
    public PlaceholderExpansion getExpansion(@NotNull String identifier) {
        this.expansionsLock.lock();
        try {
            PlaceholderExpansion placeholderExpansion = this.expansions.get(identifier.toLowerCase(Locale.ROOT));
            return placeholderExpansion;
        }
        finally {
            this.expansionsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Optional<PlaceholderExpansion> findExpansionByName(@NotNull String name) {
        this.expansionsLock.lock();
        try {
            PlaceholderExpansion bestMatch = null;
            for (Map.Entry<String, PlaceholderExpansion> entry : this.expansions.entrySet()) {
                PlaceholderExpansion expansion = entry.getValue();
                if (!expansion.getName().equalsIgnoreCase(name)) continue;
                bestMatch = expansion;
                break;
            }
            Optional<Object> optional = Optional.ofNullable(bestMatch);
            return optional;
        }
        finally {
            this.expansionsLock.unlock();
        }
    }

    @NotNull
    public Optional<PlaceholderExpansion> findExpansionByIdentifier(@NotNull String identifier) {
        return Optional.ofNullable(this.getExpansion(identifier));
    }

    public Optional<PlaceholderExpansion> register(@NotNull Class<? extends PlaceholderExpansion> clazz) {
        try {
            PlaceholderExpansion expansion = this.createExpansionInstance(clazz);
            if (expansion == null) {
                return Optional.empty();
            }
            Objects.requireNonNull(expansion.getAuthor(), "The expansion author is null!");
            Objects.requireNonNull(expansion.getIdentifier(), "The expansion identifier is null!");
            Objects.requireNonNull(expansion.getVersion(), "The expansion version is null!");
            if (expansion.getRequiredPlugin() != null && !expansion.getRequiredPlugin().isEmpty() && !Bukkit.getPluginManager().isPluginEnabled(expansion.getRequiredPlugin())) {
                Msg.warn("Cannot load expansion %s due to a missing plugin: %s", expansion.getIdentifier(), expansion.getRequiredPlugin());
                return Optional.empty();
            }
            expansion.setExpansionType(PlaceholderExpansion.Type.EXTERNAL);
            if (!expansion.register()) {
                Msg.warn("Cannot load expansion %s due to an unknown issue.", expansion.getIdentifier());
                return Optional.empty();
            }
            return Optional.of(expansion);
        }
        catch (LinkageError | NullPointerException ex) {
            String reason = ex instanceof LinkageError ? " (Is a dependency missing?)" : " - One of its properties is null which is not allowed!";
            Msg.severe("Failed to load expansion class %s%s", ex, clazz.getSimpleName(), reason);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public boolean register(@NotNull PlaceholderExpansion expansion) {
        Optional<CloudExpansion> cloudExpansionOptional;
        VersionSpecific nms;
        String identifier = expansion.getIdentifier().toLowerCase(Locale.ROOT);
        if (!expansion.canRegister()) {
            return false;
        }
        if (expansion.getExpansionType() == PlaceholderExpansion.Type.EXTERNAL && this.expansions.containsKey(identifier)) {
            Msg.warn("Failed to load external expansion %s. Identifier is already in use.", expansion.getIdentifier());
            return false;
        }
        if (expansion instanceof Configurable) {
            Map<String, Object> defaults = ((Configurable)((Object)expansion)).getDefaults();
            String pre = "expansions." + identifier + ".";
            FileConfiguration cfg = this.plugin.getConfig();
            boolean save = false;
            if (defaults != null) {
                for (Map.Entry<String, Object> entries : defaults.entrySet()) {
                    if (entries.getKey() == null || entries.getKey().isEmpty()) continue;
                    if (entries.getValue() == null) {
                        if (!cfg.contains(pre + entries.getKey())) continue;
                        save = true;
                        cfg.set(pre + entries.getKey(), null);
                        continue;
                    }
                    if (cfg.contains(pre + entries.getKey())) continue;
                    save = true;
                    cfg.set(pre + entries.getKey(), entries.getValue());
                }
            }
            if (save) {
                this.plugin.saveConfig();
                this.plugin.reloadConfig();
            }
        }
        if (expansion instanceof VersionSpecific && !(nms = (VersionSpecific)((Object)expansion)).isCompatibleWith(PlaceholderAPIPlugin.getServerVersion())) {
            Msg.warn("Your server version is incompatible with expansion %s %s", expansion.getIdentifier(), expansion.getVersion());
            return false;
        }
        PlaceholderExpansion removed = this.getExpansion(identifier);
        if (removed != null && !removed.unregister()) {
            return false;
        }
        ExpansionRegisterEvent event = new ExpansionRegisterEvent(expansion);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.expansionsLock.lock();
        try {
            this.expansions.put(identifier, expansion);
        }
        finally {
            this.expansionsLock.unlock();
        }
        if (expansion instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)expansion, (Plugin)this.plugin);
        }
        Msg.info("Successfully registered %s expansion: %s [%s]", expansion.getExpansionType().name().toLowerCase(), expansion.getIdentifier(), expansion.getVersion());
        if (expansion instanceof Taskable) {
            ((Taskable)((Object)expansion)).start();
        }
        if (this.plugin.getPlaceholderAPIConfig().isCloudEnabled() && expansion.getExpansionType() == PlaceholderExpansion.Type.EXTERNAL && (cloudExpansionOptional = this.plugin.getCloudExpansionManager().findCloudExpansionByName(identifier)).isPresent()) {
            CloudExpansion cloudExpansion = cloudExpansionOptional.get();
            cloudExpansion.setHasExpansion(true);
            cloudExpansion.setShouldUpdate(!cloudExpansion.getLatestVersion().equals(expansion.getVersion()));
        }
        return true;
    }

    @ApiStatus.Internal
    public boolean unregister(@NotNull PlaceholderExpansion expansion) {
        if (this.expansions.remove(expansion.getIdentifier().toLowerCase(Locale.ROOT)) == null) {
            return false;
        }
        Bukkit.getPluginManager().callEvent((Event)new ExpansionUnregisterEvent(expansion));
        if (expansion instanceof Listener) {
            HandlerList.unregisterAll((Listener)((Listener)expansion));
        }
        if (expansion instanceof Taskable) {
            ((Taskable)((Object)expansion)).stop();
        }
        if (expansion instanceof Cacheable) {
            ((Cacheable)((Object)expansion)).clear();
        }
        if (this.plugin.getPlaceholderAPIConfig().isCloudEnabled()) {
            this.plugin.getCloudExpansionManager().findCloudExpansionByName(expansion.getName()).ifPresent(cloud -> {
                cloud.setHasExpansion(false);
                cloud.setShouldUpdate(false);
            });
        }
        return true;
    }

    private void registerAll(@NotNull CommandSender sender) {
        Msg.info("Placeholder expansion registration initializing...", new Object[0]);
        Futures.onMainThread(this.plugin, this.findExpansionsOnDisk(), (classes, exception) -> {
            if (exception != null) {
                Msg.severe("Failed to load class files of expansion.", exception, new Object[0]);
                return;
            }
            List<PlaceholderExpansion> registered = classes.stream().filter(Objects::nonNull).map(this::register).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            long needsUpdate = registered.stream().map(expansion -> this.plugin.getCloudExpansionManager().findCloudExpansionByName(expansion.getName()).orElse(null)).filter(Objects::nonNull).filter(CloudExpansion::shouldUpdate).count();
            StringBuilder message = new StringBuilder(registered.size() == 0 ? "&6" : "&a").append(registered.size()).append(' ').append("placeholder hook(s) registered!");
            if (needsUpdate > 0L) {
                message.append(' ').append("&6").append(needsUpdate).append(' ').append("placeholder hook(s) have an update available.");
            }
            Msg.msg(sender, message.toString());
            Bukkit.getPluginManager().callEvent((Event)new ExpansionsLoadedEvent(registered));
        });
    }

    private void unregisterAll() {
        for (PlaceholderExpansion expansion : Sets.newHashSet(this.expansions.values())) {
            if (expansion.persist()) continue;
            expansion.unregister();
        }
    }

    @NotNull
    public @NotNull CompletableFuture<@NotNull List<@Nullable Class<? extends PlaceholderExpansion>>> findExpansionsOnDisk() {
        File[] files = this.folder.listFiles((dir, name) -> name.endsWith(".jar"));
        if (files == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return Arrays.stream(files).map(this::findExpansionInFile).collect(Futures.collector());
    }

    public @NotNull CompletableFuture<@Nullable Class<? extends PlaceholderExpansion>> findExpansionInFile(@NotNull File file) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Class<PlaceholderExpansion> expansionClass = FileUtil.findClass(file, PlaceholderExpansion.class);
                if (expansionClass == null) {
                    Msg.severe("Failed to load expansion %s, as it does not have a class which extends PlaceholderExpansion", file.getName());
                    return null;
                }
                Set expansionMethods = Arrays.stream(expansionClass.getDeclaredMethods()).map(method -> new MethodSignature(method.getName(), method.getParameterTypes())).collect(Collectors.toSet());
                if (!expansionMethods.containsAll(ABSTRACT_EXPANSION_METHODS)) {
                    Msg.severe("Failed to load expansion %s, as it does not have the required methods declared for a PlaceholderExpansion.", file.getName());
                    return null;
                }
                return expansionClass;
            }
            catch (NoClassDefFoundError | VerifyError e) {
                Msg.severe("Failed to load expansion %s (is a dependency missing?)", e, file.getName());
                return null;
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load expansion file: " + file.getAbsolutePath(), e);
                return null;
            }
        });
    }

    @Nullable
    public PlaceholderExpansion createExpansionInstance(@NotNull Class<? extends PlaceholderExpansion> clazz) throws LinkageError {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof LinkageError) {
                throw (LinkageError)ex.getCause();
            }
            Msg.warn("There was an issue with loading an expansion.", new Object[0]);
            return null;
        }
    }

    @EventHandler
    public void onQuit(@NotNull PlayerQuitEvent event) {
        for (PlaceholderExpansion expansion : this.getExpansions()) {
            if (!(expansion instanceof Cleanable)) continue;
            ((Cleanable)((Object)expansion)).cleanup(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPluginDisable(@NotNull PluginDisableEvent event) {
        String name = event.getPlugin().getName();
        if (name.equals(this.plugin.getName())) {
            return;
        }
        for (PlaceholderExpansion expansion : this.getExpansions()) {
            if (!name.equalsIgnoreCase(expansion.getRequiredPlugin())) continue;
            expansion.unregister();
            Msg.info("Unregistered placeholder expansion %s", expansion.getIdentifier());
            Msg.info("Reason: required plugin %s was disabled.", name);
        }
    }
}

