/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.requirement.type;

import java.math.BigDecimal;
import java.util.UUID;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.api.requirement.BaseRequirement;
import me.hsgamer.bettergui.api.requirement.Requirement;
import me.hsgamer.bettergui.builder.RequirementBuilder;
import me.hsgamer.bettergui.config.MessageConfig;
import me.hsgamer.bettergui.lib.core.bukkit.utils.MessageUtils;
import me.hsgamer.bettergui.lib.core.bukkit.utils.VersionUtils;
import me.hsgamer.bettergui.lib.core.common.Validate;
import me.hsgamer.bettergui.util.StringReplacerApplier;

public class VersionRequirement
extends BaseRequirement<Integer> {
    public VersionRequirement(RequirementBuilder.Input input) {
        super(input);
    }

    @Override
    protected Integer convert(Object value, UUID uuid) {
        String replaced = StringReplacerApplier.replace(String.valueOf(value).trim(), uuid, this);
        return Validate.getNumber(replaced).map(BigDecimal::intValue).orElseGet(() -> {
            MessageUtils.sendMessage(uuid, BetterGUI.getInstance().get(MessageConfig.class).getInvalidNumber(replaced));
            return 0;
        });
    }

    @Override
    protected Requirement.Result checkConverted(UUID uuid, Integer value) {
        return VersionUtils.isAtLeast(value) ? Requirement.Result.success() : Requirement.Result.fail();
    }
}

