/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.requirement.type;

import java.math.BigDecimal;
import java.util.UUID;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.api.requirement.Requirement;
import me.hsgamer.bettergui.api.requirement.TakableRequirement;
import me.hsgamer.bettergui.builder.RequirementBuilder;
import me.hsgamer.bettergui.config.MessageConfig;
import me.hsgamer.bettergui.lib.core.bukkit.utils.MessageUtils;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.common.Validate;
import me.hsgamer.bettergui.util.StringReplacerApplier;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LevelRequirement
extends TakableRequirement<Integer> {
    public LevelRequirement(RequirementBuilder.Input input) {
        super(input);
        this.getMenu().getVariableManager().register(this.getName(), StringReplacer.of((original, uuid) -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                return "";
            }
            int level = (Integer)this.getFinalValue((UUID)uuid);
            if (level > 0 && player.getLevel() < level) {
                return String.valueOf(level);
            }
            return BetterGUI.getInstance().get(MessageConfig.class).getHaveMetRequirementPlaceholder();
        }), true);
    }

    @Override
    protected Integer convert(Object value, UUID uuid) {
        String replaced = StringReplacerApplier.replace(String.valueOf(value).trim(), uuid, this);
        return Validate.getNumber(replaced).map(BigDecimal::intValue).orElseGet(() -> {
            MessageUtils.sendMessage(uuid, BetterGUI.getInstance().get(MessageConfig.class).getInvalidNumber(replaced));
            return 0;
        });
    }

    @Override
    protected Requirement.Result checkConverted(UUID uuid, Integer value) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return Requirement.Result.success();
        }
        if (value > 0 && player.getLevel() < value) {
            return Requirement.Result.fail();
        }
        return this.successConditional((UUID uuid1) -> {
            Player player1 = Bukkit.getPlayer((UUID)uuid1);
            if (player1 == null) {
                return;
            }
            player1.setLevel(player1.getLevel() - value);
        });
    }

    @Override
    protected boolean getDefaultTake() {
        return true;
    }

    @Override
    protected Object getDefaultValue() {
        return "0";
    }
}

