/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.requirement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.bettergui.action.ActionApplier;
import me.hsgamer.bettergui.api.button.WrappedButton;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.api.process.ProcessApplier;
import me.hsgamer.bettergui.api.requirement.Requirement;
import me.hsgamer.bettergui.lib.core.bukkit.clicktype.BukkitClickType;
import me.hsgamer.bettergui.lib.core.bukkit.clicktype.ClickTypeUtils;
import me.hsgamer.bettergui.lib.core.collections.map.CaseInsensitiveStringMap;
import me.hsgamer.bettergui.lib.core.common.MapUtils;
import me.hsgamer.bettergui.lib.core.task.element.TaskPool;
import me.hsgamer.bettergui.lib.core.task.element.TaskProcess;
import me.hsgamer.bettergui.requirement.RequirementSet;

public class RequirementApplier
implements ProcessApplier {
    public static final RequirementApplier EMPTY = new RequirementApplier(Collections.emptyList(), ActionApplier.EMPTY);
    private final List<RequirementSet> requirementSets;
    private final ActionApplier failActionApplier;

    public RequirementApplier(List<RequirementSet> requirementSets, ActionApplier failActionApplier) {
        this.requirementSets = requirementSets;
        this.failActionApplier = failActionApplier;
    }

    public RequirementApplier(Menu menu, String name, Map<String, Object> section) {
        this.requirementSets = new ArrayList<RequirementSet>();
        CaseInsensitiveStringMap<Object> keys = new CaseInsensitiveStringMap<Object>(section);
        keys.forEach((key, value) -> {
            if (value instanceof Map) {
                this.requirementSets.add(new RequirementSet(menu, name + "_reqset_" + key, (Map)value));
            }
        });
        this.failActionApplier = Optional.ofNullable(MapUtils.getIfFound(keys, "fail-command", "fail-action")).map(o -> new ActionApplier(menu, o)).orElse(ActionApplier.EMPTY);
    }

    public static Map<BukkitClickType, RequirementApplier> convertClickRequirementAppliers(Map<String, Object> section, WrappedButton button) {
        ConcurrentHashMap<BukkitClickType, RequirementApplier> clickRequirements = new ConcurrentHashMap<BukkitClickType, RequirementApplier>();
        Map<String, BukkitClickType> clickTypeMap = ClickTypeUtils.getClickTypeMap();
        CaseInsensitiveStringMap<Object> keys = new CaseInsensitiveStringMap<Object>(section);
        boolean simpleInput = true;
        ArrayList<BukkitClickType> remainingClickTypes = new ArrayList<BukkitClickType>();
        for (Map.Entry<String, BukkitClickType> entry : clickTypeMap.entrySet()) {
            String clickTypeName = entry.getKey();
            BukkitClickType clickType = entry.getValue();
            Optional optionalSubSection = Optional.ofNullable(keys.get(clickTypeName)).flatMap(MapUtils::castOptionalStringObjectMap);
            if (!optionalSubSection.isPresent()) {
                remainingClickTypes.add(clickType);
                continue;
            }
            simpleInput = false;
            clickRequirements.put(clickType, new RequirementApplier(button.getMenu(), button.getName() + "_click_" + clickTypeName.toLowerCase(Locale.ROOT), (Map)optionalSubSection.get()));
        }
        RequirementApplier defaultSetting = new RequirementApplier(button.getMenu(), button.getName() + "_click_default", Optional.ofNullable(keys.get("default")).flatMap(MapUtils::castOptionalStringObjectMap).orElse(simpleInput ? section : Collections.emptyMap()));
        for (BukkitClickType clickType : remainingClickTypes) {
            clickRequirements.put(clickType, defaultSetting);
        }
        return clickRequirements;
    }

    public boolean isEmpty() {
        return this.requirementSets.isEmpty() && this.failActionApplier.isEmpty();
    }

    public Requirement.Result getResult(UUID uuid) {
        boolean success;
        List appliers;
        if (this.requirementSets.isEmpty()) {
            appliers = Collections.emptyList();
            success = true;
        } else {
            appliers = new ArrayList();
            success = false;
            for (RequirementSet requirementSet : this.requirementSets) {
                Requirement.Result result = requirementSet.check(uuid);
                appliers.add(result.applier);
                if (!result.isSuccess) continue;
                success = true;
                break;
            }
        }
        if (!success) {
            appliers.add(this.failActionApplier);
        }
        return new Requirement.Result(success, (uuid1, process) -> {
            for (ProcessApplier applier : appliers) {
                process.getCurrentTaskPool().addLast(process1 -> applier.accept(uuid1, process1));
            }
        });
    }

    @Override
    public void accept(UUID uuid, TaskProcess process) {
        Requirement.Result result = this.getResult(uuid);
        TaskPool taskPool = process.getTaskPool(9);
        taskPool.addLast(process1 -> result.applier.accept(uuid, process1));
        process.next();
    }
}

