/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.papi;

import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.variable.VariableManager;
import me.hsgamer.bettergui.lib.minelib.plugin.base.Loadable;
import me.hsgamer.bettergui.util.StringReplacerApplier;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class ExtraPlaceholderExpansion
extends PlaceholderExpansion
implements Loadable {
    private final BetterGUI plugin;

    public ExtraPlaceholderExpansion(BetterGUI plugin) {
        this.plugin = plugin;
    }

    @Override
    public void enable() {
        this.register();
    }

    @Override
    public void disable() {
        this.unregister();
    }

    @NotNull
    public String getIdentifier() {
        return this.plugin.getName().toLowerCase(Locale.ROOT);
    }

    public boolean persist() {
        return true;
    }

    public boolean register() {
        boolean success = super.register();
        if (success) {
            VariableManager.GLOBAL.addExternalReplacer(StringReplacer.of(original -> {
                try {
                    return PlaceholderAPI.setPlaceholders(null, (String)original);
                }
                catch (Throwable throwable) {
                    this.plugin.getLogger().log(Level.WARNING, "Error while replacing placeholders", throwable);
                    return original;
                }
            }, (original, uuid) -> {
                try {
                    return PlaceholderAPI.setPlaceholders((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)uuid), (String)original);
                }
                catch (Throwable throwable) {
                    this.plugin.getLogger().log(Level.WARNING, "Error while replacing placeholders", throwable);
                    return original;
                }
            }));
        }
        return success;
    }

    @NotNull
    public String getAuthor() {
        return Arrays.toString(this.plugin.getDescription().getAuthors().toArray());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onRequest(OfflinePlayer player, @NotNull String identifier) {
        return StringReplacerApplier.replace(StringReplacerApplier.normalizeQuery(identifier), player.getUniqueId(), true);
    }
}

