/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.menu;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.api.requirement.Requirement;
import me.hsgamer.bettergui.builder.InventoryBuilder;
import me.hsgamer.bettergui.lib.core.bukkit.gui.BukkitGUIDisplay;
import me.hsgamer.bettergui.lib.core.bukkit.gui.BukkitGUIHolder;
import me.hsgamer.bettergui.lib.core.common.MapUtils;
import me.hsgamer.bettergui.lib.core.common.Pair;
import me.hsgamer.bettergui.lib.core.common.Validate;
import me.hsgamer.bettergui.lib.core.config.Config;
import me.hsgamer.bettergui.lib.core.minecraft.gui.InventoryGUIDisplay;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.ButtonMap;
import me.hsgamer.bettergui.lib.core.minecraft.gui.event.ClickEvent;
import me.hsgamer.bettergui.lib.core.minecraft.gui.event.CloseEvent;
import me.hsgamer.bettergui.lib.core.minecraft.gui.event.OpenEvent;
import me.hsgamer.bettergui.lib.core.task.BatchRunnable;
import me.hsgamer.bettergui.lib.core.task.element.TaskProcess;
import me.hsgamer.bettergui.lib.minelib.scheduler.common.task.Task;
import me.hsgamer.bettergui.menu.BaseMenu;
import me.hsgamer.bettergui.util.SchedulerUtil;
import me.hsgamer.bettergui.util.StringReplacerApplier;
import me.hsgamer.bettergui.util.TickUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class BaseInventoryMenu<B extends ButtonMap>
extends BaseMenu {
    private final BukkitGUIHolder guiHolder;
    private final B buttonMap;
    private final Set<UUID> forceClose = new ConcurrentSkipListSet<UUID>();
    private final Map<UUID, UpdateTask> updateTasks = new ConcurrentHashMap<UUID, UpdateTask>();
    private final long refreshMillis;

    protected BaseInventoryMenu(Config config) {
        super(config);
        this.guiHolder = new BukkitGUIHolder((Plugin)BetterGUI.getInstance()){

            @Override
            @NotNull
            protected BukkitGUIDisplay newDisplay(UUID uuid) {
                BukkitGUIDisplay guiDisplay = super.newDisplay(uuid);
                if (BaseInventoryMenu.this.refreshMillis >= 0L) {
                    long millis = BaseInventoryMenu.this.refreshMillis == 0L ? 50L : BaseInventoryMenu.this.refreshMillis;
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    assert (player != null);
                    UpdateTask task = new UpdateTask(guiDisplay::update, millis);
                    BaseInventoryMenu.this.updateTasks.put(uuid, task);
                }
                return guiDisplay;
            }

            @Override
            protected void onRemoveDisplay(@NotNull BukkitGUIDisplay display) {
                Optional.ofNullable((UpdateTask)BaseInventoryMenu.this.updateTasks.remove(display.getUniqueId())).ifPresent(UpdateTask::stop);
                super.onRemoveDisplay(display);
            }

            @Override
            protected void onOpen(@NotNull OpenEvent event) {
                UUID uuid = event.getViewerID();
                if (!BaseInventoryMenu.this.openActionApplier.isEmpty()) {
                    BatchRunnable batchRunnable = new BatchRunnable();
                    batchRunnable.getTaskPool(99).addLast(process -> BaseInventoryMenu.this.openActionApplier.accept(uuid, (TaskProcess)process));
                    SchedulerUtil.async().run(batchRunnable);
                }
                Optional.ofNullable((UpdateTask)BaseInventoryMenu.this.updateTasks.get(uuid)).ifPresent(UpdateTask::start);
            }

            @Override
            protected void onClose(@NotNull CloseEvent event) {
                UUID uuid = event.getViewerID();
                if (!BaseInventoryMenu.this.closeActionApplier.isEmpty()) {
                    BatchRunnable batchRunnable = new BatchRunnable();
                    batchRunnable.getTaskPool(99).addLast(process -> BaseInventoryMenu.this.closeActionApplier.accept(uuid, (TaskProcess)process));
                    SchedulerUtil.async().run(batchRunnable);
                }
                if (!BaseInventoryMenu.this.closeRequirementApplier.isEmpty()) {
                    if (BaseInventoryMenu.this.forceClose.contains(uuid)) {
                        BaseInventoryMenu.this.forceClose.remove(uuid);
                        return;
                    }
                    Requirement.Result result = BaseInventoryMenu.this.closeRequirementApplier.getResult(uuid);
                    BatchRunnable batchRunnable = new BatchRunnable();
                    batchRunnable.getTaskPool(9).addLast(process -> {
                        result.applier.accept(uuid, process);
                        process.next();
                    });
                    SchedulerUtil.async().run(batchRunnable);
                    if (!result.isSuccess) {
                        event.setRemoveDisplay(false);
                        BaseInventoryMenu.this.guiHolder.getDisplay(uuid).ifPresent(display -> {
                            Player player = Bukkit.getPlayer((UUID)uuid);
                            if (player != null) {
                                SchedulerUtil.entity((Entity)player).run(() -> player.openInventory(display.getInventory()));
                            }
                        });
                    }
                }
            }
        };
        Optional.ofNullable(MapUtils.getIfFound(this.menuSettings, "inventory-type", "inventory")).ifPresent(o -> {
            try {
                this.guiHolder.setInventoryType(InventoryType.valueOf((String)String.valueOf(o).toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException e) {
                BetterGUI.getInstance().getLogger().warning(() -> "The menu \"" + this.getName() + "\" contains an illegal inventory type");
            }
        });
        Optional.ofNullable(this.menuSettings.get("rows")).map(String::valueOf).flatMap(Validate::getNumber).map(BigDecimal::intValue).map(i -> Math.max(1, i)).map(i -> i * 9).ifPresent(this.guiHolder::setSize);
        Optional.ofNullable(this.menuSettings.get("slots")).map(String::valueOf).flatMap(Validate::getNumber).map(BigDecimal::intValue).map(i -> Math.max(1, i)).ifPresent(this.guiHolder::setSize);
        this.refreshMillis = Optional.ofNullable(MapUtils.getIfFound(this.menuSettings, "auto-refresh", "ticks")).map(String::valueOf).flatMap(TickUtil::toMillis).orElse(0L);
        Optional.ofNullable(this.menuSettings.get("cached")).map(String::valueOf).map(Boolean::parseBoolean).ifPresent(cached -> this.guiHolder.addEventConsumer(CloseEvent.class, closeEvent -> closeEvent.setRemoveDisplay(cached == false)));
        Optional.ofNullable(MapUtils.getIfFound(this.menuSettings, "name", "title")).map(String::valueOf).ifPresent(s -> this.guiHolder.setTitleFunction(uuid -> StringReplacerApplier.replace(s, uuid, this)));
        Optional.ofNullable(this.menuSettings.get("creator")).map(String::valueOf).flatMap(s -> InventoryBuilder.INSTANCE.build((String)s, Pair.of(this, this.menuSettings))).ifPresent(this.guiHolder::setInventoryFunction);
        final long clickDelay = Optional.ofNullable(MapUtils.getIfFound(this.menuSettings, "click-delay")).map(String::valueOf).flatMap(Validate::getNumber).map(BigDecimal::longValue).orElse(50L);
        if (clickDelay > 0L) {
            this.guiHolder.addEventConsumer(ClickEvent.class, new Consumer<ClickEvent>(){
                private final Map<UUID, Long> lastClickMap = new ConcurrentHashMap<UUID, Long>();

                @Override
                public void accept(ClickEvent clickEvent) {
                    long lastClick;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - (lastClick = this.lastClickMap.getOrDefault(clickEvent.getViewerID(), 0L).longValue()) < clickDelay) {
                        clickEvent.setButtonExecute(false);
                        return;
                    }
                    this.lastClickMap.put(clickEvent.getViewerID(), currentTime);
                }
            });
        }
        this.buttonMap = this.createButtonMap();
        this.guiHolder.setButtonMap((ButtonMap)this.buttonMap);
        this.guiHolder.init();
    }

    @Override
    protected boolean createChecked(Player player, String[] args, boolean bypass) {
        UUID uuid = player.getUniqueId();
        this.refreshButtonMapOnCreate(this.buttonMap, uuid);
        ((BukkitGUIDisplay)this.guiHolder.createDisplay(uuid)).open();
        return true;
    }

    @Override
    public void update(Player player) {
        this.guiHolder.getDisplay(player.getUniqueId()).ifPresent(InventoryGUIDisplay::update);
    }

    @Override
    public void close(Player player) {
        this.forceClose.add(player.getUniqueId());
        player.closeInventory();
    }

    @Override
    public void closeAll() {
        this.guiHolder.stop();
    }

    protected abstract B createButtonMap();

    protected void refreshButtonMapOnCreate(B buttonMap, UUID uuid) {
    }

    public B getButtonMap() {
        return this.buttonMap;
    }

    public BukkitGUIHolder getGUIHolder() {
        return this.guiHolder;
    }

    private static class UpdateTask {
        private final Runnable runnable;
        private final long millis;
        private Task task;

        private UpdateTask(Runnable runnable, long millis) {
            this.runnable = runnable;
            this.millis = millis;
        }

        public void start() {
            if (this.task != null && !this.task.isCancelled()) {
                return;
            }
            this.task = SchedulerUtil.async().runTimer(() -> {
                this.runnable.run();
                return true;
            }, this.millis, this.millis, TimeUnit.MILLISECONDS);
        }

        public void stop() {
            if (this.task != null) {
                this.task.cancel();
            }
        }
    }
}

