/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.menu;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.builder.ItemModifierBuilder;
import me.hsgamer.bettergui.config.MessageConfig;
import me.hsgamer.bettergui.downloader.AdditionalInfoKeys;
import me.hsgamer.bettergui.downloader.AddonDownloader;
import me.hsgamer.bettergui.lib.core.bukkit.gui.event.BukkitClickEvent;
import me.hsgamer.bettergui.lib.core.bukkit.gui.object.BukkitItem;
import me.hsgamer.bettergui.lib.core.bukkit.item.BukkitItemBuilder;
import me.hsgamer.bettergui.lib.core.bukkit.utils.MessageUtils;
import me.hsgamer.bettergui.lib.core.common.MapUtils;
import me.hsgamer.bettergui.lib.core.config.Config;
import me.hsgamer.bettergui.lib.core.downloader.core.object.DownloadInfo;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.Button;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.ButtonMap;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.DisplayButton;
import me.hsgamer.bettergui.lib.core.minecraft.gui.object.InventorySize;
import me.hsgamer.bettergui.lib.core.minecraft.item.ItemBuilder;
import me.hsgamer.bettergui.lib.core.ui.property.Initializable;
import me.hsgamer.bettergui.manager.AddonManager;
import me.hsgamer.bettergui.menu.BaseInventoryMenu;
import me.hsgamer.bettergui.util.StringReplacerApplier;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddonMenu
extends BaseInventoryMenu<ButtonMap> {
    private static final String MESSAGE_PATH = "message";
    private static final String STATUS_PATH = "status";
    private static final String BUTTON_PATH = "button";
    private final String upToDateMessage;
    private final String downloadingMessage;
    private final String stillDownloadingMessage;
    private final String downloadFinishedMessage;
    private final String upToDateStatus;
    private final String availableStatus;
    private final String outdatedStatus;

    public AddonMenu(Config config) {
        super(config);
        this.upToDateMessage = Objects.toString(config.get((Object)"&cIt's already up-to-date", MESSAGE_PATH, "up-to-date"));
        this.downloadingMessage = Objects.toString(config.get((Object)"&eDownloading {addon}", MESSAGE_PATH, "downloading"));
        this.stillDownloadingMessage = Objects.toString(config.get((Object)"&cIt's still downloading", MESSAGE_PATH, "still-downloading"));
        this.downloadFinishedMessage = Objects.toString(config.get((Object)"&aDownload finished", MESSAGE_PATH, "download-finished"));
        this.upToDateStatus = Objects.toString(config.get((Object)"&aUp-to-date", STATUS_PATH, "up-to-date"));
        this.availableStatus = Objects.toString(config.get((Object)"&aAvailable", STATUS_PATH, "available"));
        this.outdatedStatus = Objects.toString(config.get((Object)"&cOutdated", STATUS_PATH, "outdated"));
    }

    @Override
    protected ButtonMap createButtonMap() {
        Optional<Map<String, Object>> optionalMap = MapUtils.castOptionalStringObjectMap(this.configSettings.get(BUTTON_PATH));
        if (!optionalMap.isPresent()) {
            throw new IllegalStateException("The button map must be a map");
        }
        final Map<String, Object> itemMap = optionalMap.get();
        return new ButtonMap(){
            private final Map<DownloadInfo, AddonButton> addonButtonMap = new HashMap<DownloadInfo, AddonButton>();

            @Override
            @NotNull
            public @NotNull Map<@NotNull Integer, @NotNull DisplayButton> getButtons(@NotNull UUID uuid, InventorySize inventorySize) {
                HashMap<Integer, DisplayButton> buttonMap = new HashMap<Integer, DisplayButton>();
                Collection<DownloadInfo> downloadInfos = BetterGUI.getInstance().get(AddonDownloader.class).getDownloader().getLoadedDownloadInfo().values();
                int slot = 0;
                for (DownloadInfo info : downloadInfos) {
                    AddonButton button = this.addonButtonMap.computeIfAbsent(info, downloadInfo -> {
                        BukkitItemBuilder itemBuilder = new BukkitItemBuilder();
                        ItemModifierBuilder.INSTANCE.build(itemMap).forEach(itemBuilder::addItemModifier);
                        AddonButton addonButton = new AddonButton((DownloadInfo)downloadInfo, itemBuilder);
                        addonButton.init();
                        return addonButton;
                    });
                    buttonMap.put(slot++, button.display(uuid));
                }
                return buttonMap;
            }

            @Override
            public void stop() {
                this.addonButtonMap.values().forEach(Initializable::stop);
                this.addonButtonMap.clear();
            }
        };
    }

    private class AddonButton
    implements Button {
        private final DownloadInfo downloadInfo;
        private final ItemBuilder<ItemStack> itemBuilder;
        private String status = "";

        AddonButton(DownloadInfo downloadInfo, ItemBuilder<ItemStack> itemBuilder) {
            this.downloadInfo = downloadInfo;
            this.itemBuilder = itemBuilder;
            itemBuilder.addStringReplacer(original -> original.replace("{status}", this.status).replace("{name}", downloadInfo.getName()).replace("{version}", downloadInfo.getVersion()).replace("{description}", AdditionalInfoKeys.DESCRIPTION.get(downloadInfo)).replace("{author}", AdditionalInfoKeys.AUTHORS.get(downloadInfo).toString()));
            itemBuilder.addStringReplacer(StringReplacerApplier.COLORIZE);
        }

        private void updateStatus() {
            this.status = BetterGUI.getInstance().get(AddonManager.class).getExpansionClassLoader(this.downloadInfo.getName()).map(addon -> addon.getDescription().getVersion().equals(this.downloadInfo.getVersion()) ? AddonMenu.this.upToDateStatus : AddonMenu.this.outdatedStatus).orElse(AddonMenu.this.availableStatus);
        }

        @Override
        public void init() {
            this.updateStatus();
        }

        @Override
        @Nullable
        public DisplayButton display(@NotNull UUID uuid) {
            this.updateStatus();
            return new DisplayButton().setItem(new BukkitItem(this.itemBuilder.build(uuid))).setClickAction(clickEvent -> {
                if (!(clickEvent instanceof BukkitClickEvent)) {
                    return;
                }
                InventoryClickEvent event = (InventoryClickEvent)((BukkitClickEvent)clickEvent).getEvent();
                HumanEntity humanEntity = event.getWhoClicked();
                ClickType clickType = event.getClick();
                if (clickType.isLeftClick()) {
                    if (this.status.equals(AddonMenu.this.upToDateStatus)) {
                        MessageUtils.sendMessage((CommandSender)humanEntity, AddonMenu.this.upToDateMessage);
                        return;
                    }
                    if (this.downloadInfo.isDownloading()) {
                        MessageUtils.sendMessage((CommandSender)humanEntity, AddonMenu.this.stillDownloadingMessage);
                    } else {
                        MessageUtils.sendMessage((CommandSender)humanEntity, AddonMenu.this.downloadingMessage.replace("{addon}", this.downloadInfo.getName()));
                        this.downloadInfo.download().whenComplete((file, throwable) -> {
                            if (throwable != null) {
                                BetterGUI.getInstance().getLogger().log(Level.WARNING, (Throwable)throwable, () -> "Unexpected issue when downloading " + this.downloadInfo.getName());
                                MessageUtils.sendMessage((CommandSender)humanEntity, "&cAn unexpected issue occurs when downloading. Check the console");
                                return;
                            }
                            MessageUtils.sendMessage((CommandSender)humanEntity, AddonMenu.this.downloadFinishedMessage);
                        });
                        MessageUtils.sendMessage((CommandSender)humanEntity, BetterGUI.getInstance().get(MessageConfig.class).getSuccess());
                    }
                } else if (clickType.isRightClick()) {
                    MessageUtils.sendMessage((CommandSender)humanEntity, "&bLink: &f" + AdditionalInfoKeys.SOURCE_CODE.get(this.downloadInfo));
                } else if (clickType.equals((Object)ClickType.MIDDLE)) {
                    MessageUtils.sendMessage((CommandSender)humanEntity, "&bLink: &f" + AdditionalInfoKeys.WIKI.get(this.downloadInfo));
                }
            });
        }
    }
}

