/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.manager;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.builder.ConfigBuilder;
import me.hsgamer.bettergui.builder.MenuBuilder;
import me.hsgamer.bettergui.config.MainConfig;
import me.hsgamer.bettergui.lib.minelib.plugin.base.Loadable;
import me.hsgamer.bettergui.lib.minelib.plugin.postenable.PostEnable;
import org.bukkit.entity.Player;

public final class MenuManager
implements Loadable,
PostEnable {
    private final Map<String, Menu> menuMap = new HashMap<String, Menu>();
    private final BetterGUI plugin;
    private final File menusFolder;

    public MenuManager(BetterGUI plugin) {
        this.plugin = plugin;
        this.menusFolder = new File(plugin.getDataFolder(), "menu");
    }

    public void loadMenuConfig() {
        if (!this.menusFolder.exists() && this.menusFolder.mkdirs()) {
            this.plugin.saveResource("menu/example.yml", false);
            this.plugin.saveResource("menu/addondownloader.yml", false);
        }
        LinkedList<File> files = new LinkedList<File>();
        files.add(this.menusFolder);
        while (!files.isEmpty()) {
            File file = (File)files.pop();
            if (file.isDirectory()) {
                files.addAll(Arrays.asList(Objects.requireNonNull(file.listFiles())));
                continue;
            }
            if (!file.isFile()) continue;
            this.registerMenu(file);
        }
    }

    public void registerMenu(File file) {
        String name = this.plugin.get(MainConfig.class).getFileName(this.menusFolder, file);
        if (this.menuMap.containsKey(name)) {
            this.plugin.getLogger().log(Level.WARNING, "\"{0}\" is already available in the menu manager. Ignored", name);
        } else {
            ConfigBuilder.INSTANCE.build(file).flatMap(config -> {
                config.setup();
                return MenuBuilder.INSTANCE.build(config);
            }).ifPresent(menu -> this.menuMap.put(name, (Menu)menu));
        }
    }

    public void clear() {
        this.menuMap.values().forEach(Menu::closeAll);
        this.menuMap.clear();
    }

    public boolean contains(String name) {
        return this.menuMap.containsKey(name);
    }

    public void openMenu(String name, Player player, String[] args, boolean bypass) {
        this.menuMap.get(name).create(player, args, bypass);
    }

    public void openMenu(String name, Player player, String[] args, Menu parentMenu, boolean bypass) {
        Menu menu = this.menuMap.get(name);
        menu.setParentMenu(player.getUniqueId(), parentMenu);
        menu.create(player, args, bypass);
    }

    public List<String> tabCompleteMenu(String name, Player player, String[] args) {
        return this.menuMap.get(name).tabComplete(player, args);
    }

    public Collection<String> getMenuNames() {
        return this.menuMap.keySet();
    }

    public Menu getMenu(String name) {
        return this.menuMap.get(name);
    }

    @Override
    public void postEnable() {
        this.loadMenuConfig();
    }

    @Override
    public void disable() {
        this.clear();
    }
}

