/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.Permissions;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.config.MessageConfig;
import me.hsgamer.bettergui.lib.core.bukkit.utils.MessageUtils;
import me.hsgamer.bettergui.lib.minelib.plugin.base.Loadable;
import me.hsgamer.bettergui.lib.minelib.plugin.command.CommandComponent;
import me.hsgamer.bettergui.lib.minelib.plugin.postenable.PostEnable;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MenuCommandManager
implements Loadable,
PostEnable {
    private final Map<String, Command> registeredMenuCommand = new HashMap<String, Command>();
    private final BetterGUI plugin;

    public MenuCommandManager(BetterGUI plugin) {
        this.plugin = plugin;
    }

    public void registerMenuCommand(String command, final Menu menu) {
        this.registerMenuCommand(new Command(command){

            public boolean execute(CommandSender commandSender, String s, String[] strings) {
                if (commandSender instanceof Player) {
                    menu.create((Player)commandSender, strings, commandSender.hasPermission(Permissions.OPEN_MENU_BYPASS));
                    return true;
                }
                MessageUtils.sendMessage(commandSender, MenuCommandManager.this.plugin.get(MessageConfig.class).getPlayerOnly());
                return false;
            }

            public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
                if (sender instanceof Player) {
                    return menu.tabComplete((Player)sender, args);
                }
                return Collections.emptyList();
            }
        });
    }

    public void registerMenuCommand(Command command) {
        String name = command.getName();
        if (this.registeredMenuCommand.containsKey(name)) {
            this.plugin.getLogger().log(Level.WARNING, "Duplicated \"{0}\" command ! Ignored", name);
            return;
        }
        CommandComponent.registerCommandToCommandMap(this.plugin.getName() + "_menu", command);
        this.registeredMenuCommand.put(name, command);
    }

    public void clearMenuCommand() {
        this.registeredMenuCommand.values().forEach(CommandComponent::unregisterFromKnownCommands);
        this.registeredMenuCommand.clear();
    }

    public Map<String, Command> getRegisteredMenuCommand() {
        return this.registeredMenuCommand;
    }

    @Override
    public void postEnable() {
        CommandComponent.syncCommand();
    }

    @Override
    public void disable() {
        this.clearMenuCommand();
    }
}

