/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.minelib.scheduler.entity;

import java.util.function.BooleanSupplier;
import me.hsgamer.bettergui.lib.minelib.scheduler.common.scheduler.Scheduler;
import me.hsgamer.bettergui.lib.minelib.scheduler.common.task.Task;
import me.hsgamer.bettergui.lib.minelib.scheduler.common.util.Platform;
import me.hsgamer.bettergui.lib.minelib.scheduler.entity.BukkitEntityScheduler;
import me.hsgamer.bettergui.lib.minelib.scheduler.entity.FoliaEntityScheduler;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public interface EntityScheduler
extends Scheduler {
    public static boolean isEntityValid(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof Player) {
            return ((Player)entity).isOnline();
        }
        return entity.isValid();
    }

    public static EntityScheduler get(Plugin plugin, Entity entity) {
        return Platform.FOLIA.isPlatform() ? new FoliaEntityScheduler(plugin, entity) : new BukkitEntityScheduler(plugin, entity);
    }

    public Task run(Runnable var1, Runnable var2);

    public Task runLater(Runnable var1, Runnable var2, long var3);

    public Task runTimer(BooleanSupplier var1, Runnable var2, long var3, long var5);

    default public Task runTimer(Runnable runnable, Runnable retired, long delay, long period) {
        return this.runTimer(() -> {
            runnable.run();
            return true;
        }, retired, delay, period);
    }

    @Override
    default public Task run(Runnable runnable) {
        return this.run(runnable, () -> {});
    }

    @Override
    default public Task runLater(Runnable runnable, long delay) {
        return this.runLater(runnable, () -> {}, delay);
    }

    @Override
    default public Task runTimer(BooleanSupplier runnable, long delay, long period) {
        return this.runTimer(runnable, () -> {}, delay, period);
    }
}

