/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.minelib.scheduler.entity;

import java.util.function.BooleanSupplier;
import me.hsgamer.bettergui.lib.minelib.scheduler.common.task.Task;
import me.hsgamer.bettergui.lib.minelib.scheduler.common.util.task.BukkitTask;
import me.hsgamer.bettergui.lib.minelib.scheduler.entity.EntityScheduler;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

class BukkitEntityScheduler
implements EntityScheduler {
    private final Plugin plugin;
    private final Entity entity;

    BukkitEntityScheduler(Plugin plugin, Entity entity) {
        this.plugin = plugin;
        this.entity = entity;
    }

    private BukkitRunnable wrapRunnable(final BooleanSupplier runnable, final Runnable retired) {
        return new BukkitRunnable(){

            public void run() {
                if (EntityScheduler.isEntityValid(BukkitEntityScheduler.this.entity)) {
                    if (!runnable.getAsBoolean()) {
                        this.cancel();
                    }
                } else {
                    retired.run();
                    this.cancel();
                }
            }
        };
    }

    private BukkitRunnable wrapRunnable(Runnable runnable, Runnable retired) {
        return this.wrapRunnable(() -> {
            runnable.run();
            return true;
        }, retired);
    }

    @Override
    public Task run(Runnable runnable, Runnable retired) {
        return new BukkitTask(this.wrapRunnable(runnable, retired).runTask(this.plugin));
    }

    @Override
    public Task runLater(Runnable runnable, Runnable retired, long delay) {
        return new BukkitTask(this.wrapRunnable(runnable, retired).runTaskLater(this.plugin, delay));
    }

    @Override
    public Task runTimer(BooleanSupplier runnable, Runnable retired, long delay, long period) {
        return new BukkitTask(this.wrapRunnable(runnable, retired).runTaskTimer(this.plugin, delay, period));
    }
}

