/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.minelib.scheduler.async;

import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import me.hsgamer.bettergui.lib.minelib.scheduler.async.AsyncScheduler;
import me.hsgamer.bettergui.lib.minelib.scheduler.common.task.Task;
import me.hsgamer.bettergui.lib.minelib.scheduler.common.util.task.BukkitTask;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

class BukkitAsyncScheduler
implements AsyncScheduler {
    private final Plugin plugin;

    BukkitAsyncScheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    private static long toTicks(long time, TimeUnit unit) {
        return unit.toMillis(time) / 50L;
    }

    @Override
    public Task run(Runnable runnable) {
        return new BukkitTask(Bukkit.getScheduler().runTaskAsynchronously(this.plugin, runnable));
    }

    @Override
    public Task runLater(Runnable runnable, long delay) {
        return new BukkitTask(Bukkit.getScheduler().runTaskLaterAsynchronously(this.plugin, runnable, delay));
    }

    @Override
    public Task runTimer(BooleanSupplier runnable, long delay, long period) {
        return new BukkitTask(BukkitTask.wrapRunnable(runnable).runTaskTimerAsynchronously(this.plugin, delay, period));
    }

    @Override
    public Task runLater(Runnable runnable, long delay, TimeUnit unit) {
        return this.runLater(runnable, BukkitAsyncScheduler.toTicks(delay, unit));
    }

    @Override
    public Task runTimer(BooleanSupplier runnable, long delay, long period, TimeUnit unit) {
        return this.runTimer(runnable, BukkitAsyncScheduler.toTicks(delay, unit), BukkitAsyncScheduler.toTicks(period, unit));
    }
}

