/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.craftitem.spigot.skull.handler;

import java.net.URL;
import java.util.UUID;
import java.util.regex.Pattern;
import me.hsgamer.bettergui.lib.craftitem.spigot.skull.handler.NewSkullHandler;
import me.hsgamer.bettergui.lib.craftitem.spigot.skull.handler.OldSkullHandler;
import me.hsgamer.bettergui.lib.craftitem.spigot.skull.handler.PaperSkullHandler;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.meta.SkullMeta;

public interface SkullHandler {
    public static final Pattern MOJANG_SHA256_APPROX_PATTERN = Pattern.compile("[0-9a-z]{55,70}");
    public static final Pattern BASE64_PATTERN = Pattern.compile("[-A-Za-z0-9+/]{100,}={0,3}");

    public static SkullHandler getInstance() {
        try {
            Class.forName("com.destroystokyo.paper.profile.PlayerProfile");
            return new PaperSkullHandler();
        }
        catch (Exception e1) {
            try {
                Class.forName("org.bukkit.profile.PlayerProfile");
                return new NewSkullHandler();
            }
            catch (Exception e2) {
                return new OldSkullHandler();
            }
        }
    }

    default public void setSkullByName(SkullMeta meta, String name) {
        this.setSkullByPlayer(meta, Bukkit.getOfflinePlayer((String)name));
    }

    default public void setSkullByUUID(SkullMeta meta, UUID uuid) {
        this.setSkullByPlayer(meta, Bukkit.getOfflinePlayer((UUID)uuid));
    }

    public void setSkullByPlayer(SkullMeta var1, OfflinePlayer var2);

    public void setSkullByURL(SkullMeta var1, URL var2);

    default public void setSkullByURL(SkullMeta meta, String url) {
        try {
            this.setSkullByURL(meta, new URL(url));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setSkullByBase64(SkullMeta var1, String var2);

    default public void setSkull(SkullMeta meta, String value) {
        try {
            URL url = new URL(value);
            this.setSkullByURL(meta, url);
            return;
        }
        catch (Throwable url) {
            if (MOJANG_SHA256_APPROX_PATTERN.matcher(value).matches()) {
                this.setSkullByURL(meta, "https://textures.minecraft.net/texture/" + value);
                return;
            }
            if (BASE64_PATTERN.matcher(value).matches()) {
                this.setSkullByBase64(meta, value);
                return;
            }
            try {
                UUID uuid = UUID.fromString(value);
                this.setSkullByUUID(meta, uuid);
                return;
            }
            catch (Throwable throwable) {
                this.setSkullByName(meta, value);
                return;
            }
        }
    }

    public String getSkullValue(SkullMeta var1);
}

