/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.craftitem.spigot.skull.handler;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.net.URL;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.bettergui.lib.craftitem.spigot.skull.handler.SkullHandler;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.meta.SkullMeta;

class PaperSkullHandler
implements SkullHandler {
    private final Map<String, PlayerProfile> profileMap = new ConcurrentHashMap<String, PlayerProfile>();

    PaperSkullHandler() {
    }

    private void setSkull(SkullMeta meta, PlayerProfile profile) {
        meta.setPlayerProfile(profile);
    }

    @Override
    public void setSkullByPlayer(SkullMeta meta, OfflinePlayer player) {
        PlayerProfile profile = this.profileMap.computeIfAbsent(player.getUniqueId().toString(), s -> Bukkit.createProfile((UUID)player.getUniqueId()));
        this.setSkull(meta, profile);
    }

    @Override
    public void setSkullByURL(SkullMeta meta, URL url) {
        PlayerProfile profile = this.profileMap.computeIfAbsent(url.toString(), url1 -> {
            PlayerProfile playerProfile = Bukkit.createProfile((UUID)UUID.randomUUID());
            playerProfile.setProperty(new ProfileProperty("textures", Base64.getEncoder().encodeToString(String.format("{\"textures\":{\"SKIN\":{\"url\":\"%s\"}}}", url1).getBytes())));
            return playerProfile;
        });
        this.setSkull(meta, profile);
    }

    @Override
    public void setSkullByBase64(SkullMeta meta, String base64) {
        PlayerProfile profile = this.profileMap.computeIfAbsent(base64, b -> {
            PlayerProfile playerProfile = Bukkit.createProfile((UUID)UUID.randomUUID());
            playerProfile.setProperty(new ProfileProperty("textures", base64));
            return playerProfile;
        });
        this.setSkull(meta, profile);
    }

    @Override
    public String getSkullValue(SkullMeta meta) {
        PlayerProfile profile = meta.getPlayerProfile();
        if (profile == null) {
            return "";
        }
        ProfileProperty texturesProperty = null;
        for (ProfileProperty property : profile.getProperties()) {
            if (!property.getName().equalsIgnoreCase("textures")) continue;
            texturesProperty = property;
            break;
        }
        if (texturesProperty == null) {
            return "";
        }
        return texturesProperty.getValue();
    }
}

