/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.craftitem.spigot.skull.handler;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.bettergui.lib.craftitem.spigot.skull.handler.SkullHandler;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.meta.SkullMeta;

class OldSkullHandler
implements SkullHandler {
    private final Map<String, GameProfile> cache = new ConcurrentHashMap<String, GameProfile>();
    private final Method getProfileMethod;

    OldSkullHandler() {
        Method method = null;
        try {
            method = Property.class.getDeclaredMethod("value", new Class[0]);
        }
        catch (Exception e) {
            try {
                method = Property.class.getDeclaredMethod("getValue", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.getProfileMethod = method;
    }

    @Override
    public void setSkullByPlayer(SkullMeta meta, OfflinePlayer player) {
        try {
            meta.setOwningPlayer(player);
        }
        catch (Throwable e) {
            meta.setOwner(player.getName());
        }
    }

    private void setSkullByGameProfile(SkullMeta meta, GameProfile profile) {
        try {
            Method setProfile = meta.getClass().getMethod("setProfile", GameProfile.class);
            setProfile.setAccessible(true);
            setProfile.invoke((Object)meta, profile);
        }
        catch (Exception e) {
            try {
                Field profileField = meta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
                profileField.set(meta, profile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setSkullByURL(SkullMeta meta, URL url) {
        GameProfile profile = this.cache.computeIfAbsent(url.toString(), url1 -> {
            GameProfile gameProfile = new GameProfile(UUID.randomUUID(), "");
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", Base64.getEncoder().encodeToString(String.format("{\"textures\":{\"SKIN\":{\"url\":\"%s\"}}}", url1).getBytes())));
            return gameProfile;
        });
        this.setSkullByGameProfile(meta, profile);
    }

    @Override
    public void setSkullByBase64(SkullMeta meta, String base64) {
        GameProfile gameProfile = this.cache.computeIfAbsent(base64, b -> {
            GameProfile profile = new GameProfile(UUID.randomUUID(), "");
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", b));
            return profile;
        });
        this.setSkullByGameProfile(meta, gameProfile);
    }

    @Override
    public String getSkullValue(SkullMeta meta) {
        GameProfile profile;
        try {
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profile = (GameProfile)profileField.get(meta);
        }
        catch (Exception e) {
            return "";
        }
        if (profile == null) {
            return "";
        }
        Collection properties = profile.getProperties().get((Object)"textures");
        if (properties == null || properties.isEmpty()) {
            return "";
        }
        for (Property property : properties) {
            String value;
            if (this.getProfileMethod == null) continue;
            try {
                value = (String)this.getProfileMethod.invoke((Object)property, new Object[0]);
            }
            catch (Exception e) {
                continue;
            }
            if (value.isEmpty()) continue;
            return value;
        }
        return "";
    }
}

