/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.craftitem.nbt;

import java.util.List;
import java.util.Map;
import me.hsgamer.bettergui.lib.craftitem.nbt.NBTRaw;

public final class SNBTConverter {
    private SNBTConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated.");
    }

    public static String convert(Object value) {
        return SNBTConverter.convert(value, false);
    }

    public static String convert(Object value, boolean useDataComponentFormat) {
        if (value == null) {
            return useDataComponentFormat ? "[]" : "{}";
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return SNBTConverter.convertToCompound(map, useDataComponentFormat);
        }
        return SNBTConverter.convertValue(value);
    }

    private static String convertValue(Object value) {
        if (value == null) {
            return "\"\"";
        }
        if (value instanceof NBTRaw) {
            return ((NBTRaw)value).value;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return SNBTConverter.convertToCompound(map, false);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Byte) {
            return value + "b";
        }
        if (value instanceof Short) {
            return value + "s";
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Long) {
            return value + "L";
        }
        if (value instanceof Float) {
            return value + "f";
        }
        if (value instanceof Double) {
            return value.toString();
        }
        if (value instanceof String) {
            return SNBTConverter.convertStringValue((String)value);
        }
        if (value instanceof List) {
            List list = (List)value;
            return SNBTConverter.convertToList(list);
        }
        if (value instanceof byte[]) {
            return SNBTConverter.convertToByteArray((byte[])value);
        }
        if (value instanceof int[]) {
            return SNBTConverter.convertToIntArray((int[])value);
        }
        if (value instanceof long[]) {
            return SNBTConverter.convertToLongArray((long[])value);
        }
        return SNBTConverter.escapeString(value.toString());
    }

    private static String convertToCompound(Map<String, Object> map, boolean useDataComponentFormat) {
        StringBuilder sb = new StringBuilder();
        sb.append(useDataComponentFormat ? "[" : "{");
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            String key = entry.getKey();
            sb.append(SNBTConverter.escapeKey(key)).append(useDataComponentFormat ? "=" : ":").append(SNBTConverter.convertValue(entry.getValue()));
        }
        sb.append(useDataComponentFormat ? "]" : "}");
        return sb.toString();
    }

    private static String convertToList(List<?> list) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(SNBTConverter.convertValue(list.get(i)));
        }
        sb.append("]");
        return sb.toString();
    }

    private static String convertToByteArray(byte[] arr) {
        StringBuilder sb = new StringBuilder("[B;");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(arr[i]).append("b");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String convertToIntArray(int[] arr) {
        StringBuilder sb = new StringBuilder("[I;");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(arr[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    private static String convertToLongArray(long[] arr) {
        StringBuilder sb = new StringBuilder("[L;");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(arr[i]).append("L");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String convertStringValue(String str) {
        String numberWithSuffix = SNBTConverter.tryParseNumberWithSuffix(str = str.trim());
        if (numberWithSuffix != null) {
            return numberWithSuffix;
        }
        String plainNumber = SNBTConverter.tryParseNumber(str);
        if (plainNumber != null) {
            return plainNumber;
        }
        return SNBTConverter.escapeString(str);
    }

    private static String tryParseNumberWithSuffix(String str) {
        if (str.length() < 2) {
            return null;
        }
        char lastChar = str.charAt(str.length() - 1);
        String numPart = str.substring(0, str.length() - 1);
        try {
            switch (lastChar) {
                case 'B': 
                case 'b': {
                    Byte.parseByte(numPart);
                    return str.toLowerCase().replace('B', 'b');
                }
                case 'S': 
                case 's': {
                    Short.parseShort(numPart);
                    return str.toLowerCase().replace('S', 's');
                }
                case 'L': 
                case 'l': {
                    Long.parseLong(numPart);
                    return str.toUpperCase().replace('l', 'L');
                }
                case 'F': 
                case 'f': {
                    Float.parseFloat(numPart);
                    return str.toLowerCase().replace('F', 'f');
                }
                case 'D': 
                case 'd': {
                    Double.parseDouble(numPart);
                    return numPart;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static String tryParseNumber(String str) {
        try {
            if (str.contains(".")) {
                Double.parseDouble(str);
            } else {
                Integer.parseInt(str);
            }
            return str;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String escapeString(String str) {
        if (SNBTConverter.needsQuotes(str)) {
            return "\"" + str.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }
        return str;
    }

    private static String escapeKey(String key) {
        if (SNBTConverter.needsQuotesForKey(key)) {
            return "\"" + key.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }
        return key;
    }

    private static boolean needsQuotes(String str) {
        if (str.isEmpty()) {
            return true;
        }
        char first = str.charAt(0);
        if (Character.isDigit(first) || first == '-' || first == '.' || first == '+') {
            return true;
        }
        for (char c : str.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.' || c == '+') continue;
            return true;
        }
        return false;
    }

    private static boolean needsQuotesForKey(String key) {
        if (key.isEmpty()) {
            return true;
        }
        for (char c : key.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.' || c == '+') continue;
            return true;
        }
        return false;
    }
}

