/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.web;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.NotNull;

public final class WebUtils {
    private WebUtils() {
    }

    @NotNull
    public static URLConnection createConnection(@NotNull String address) throws IOException {
        return new URL(address).openConnection();
    }

    @NotNull
    public static URLConnection createConnection(@NotNull String address, Consumer<URLConnection> connectionConsumer) throws IOException {
        URLConnection connection = WebUtils.createConnection(address);
        connectionConsumer.accept(connection);
        return new URL(address).openConnection();
    }

    @NotNull
    public static HttpURLConnection createHttpConnection(@NotNull String address) throws IOException {
        URLConnection connection = WebUtils.createConnection(address);
        if (connection instanceof HttpURLConnection) {
            return (HttpURLConnection)connection;
        }
        connection.setConnectTimeout(5);
        throw new IOException("The URL is not a HTTP URL");
    }

    @NotNull
    public static HttpURLConnection createHttpConnection(@NotNull String address, Consumer<HttpURLConnection> connectionConsumer) throws IOException {
        HttpURLConnection connection = WebUtils.createHttpConnection(address);
        connectionConsumer.accept(connection);
        return connection;
    }

    @NotNull
    public static HttpsURLConnection createHttpsConnection(@NotNull String address) throws IOException {
        URLConnection connection = WebUtils.createConnection(address);
        if (connection instanceof HttpsURLConnection) {
            return (HttpsURLConnection)connection;
        }
        connection.setConnectTimeout(5);
        throw new IOException("The URL is not a HTTPS URL");
    }

    @NotNull
    public static HttpsURLConnection createHttpsConnection(@NotNull String address, Consumer<HttpsURLConnection> connectionConsumer) throws IOException {
        HttpsURLConnection connection = WebUtils.createHttpsConnection(address);
        connectionConsumer.accept(connection);
        return connection;
    }

    @NotNull
    public static String encodeUrl(@NotNull String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    public static String decodeUrl(@NotNull String string) {
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    public static String makeUrl(@NotNull String address, @NotNull Map<String, String> queryMap) {
        if (queryMap.isEmpty()) {
            return address;
        }
        String query = queryMap.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + WebUtils.encodeUrl((String)entry.getValue())).reduce((s1, s2) -> s1 + "&" + s2).orElse("");
        return address + "?" + query;
    }
}

