/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.variable;

import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.common.Validate;
import me.hsgamer.bettergui.lib.core.variable.VariableBundle;

public final class CommonVariableBundle {
    private CommonVariableBundle() {
    }

    public static void registerVariables(VariableBundle bundle) {
        bundle.register("random_", StringReplacer.of(original -> {
            if ((original = original.trim()).contains(":")) {
                String[] split = original.split(":", 2);
                String s1 = split[0].trim();
                String s2 = split[1].trim();
                Optional<Integer> optional1 = Validate.getNumber(s1).map(Number::intValue);
                Optional<Integer> optional2 = Validate.getNumber(s2).map(Number::intValue);
                if (optional1.isPresent() && optional2.isPresent()) {
                    int i1 = optional1.get();
                    int i2 = optional2.get();
                    int max = Math.max(i1, i2);
                    int min = Math.min(i1, i2);
                    return String.valueOf(ThreadLocalRandom.current().nextInt(min, max + 1));
                }
            } else {
                Optional<Integer> optional = Validate.getNumber(original).map(Number::intValue);
                if (optional.isPresent()) {
                    return String.valueOf(ThreadLocalRandom.current().nextInt(optional.get()));
                }
            }
            return null;
        }));
        bundle.register("uuid", StringReplacer.of((original, uuid) -> uuid.toString()), true);
    }
}

