/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.task.element;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import me.hsgamer.bettergui.lib.core.task.element.TaskProcess;

public final class TaskPool {
    private final int stage;
    private final Deque<Consumer<TaskProcess>> tasks = new ArrayDeque<Consumer<TaskProcess>>();

    public TaskPool(int stage) {
        this.stage = stage;
    }

    public TaskPool addFirst(Consumer<TaskProcess> task) {
        this.tasks.addFirst(task);
        return this;
    }

    public TaskPool addLast(Consumer<TaskProcess> task) {
        this.tasks.addLast(task);
        return this;
    }

    public TaskPool addFirst(Runnable ... task) {
        for (Runnable t : task) {
            this.tasks.addFirst(process -> {
                t.run();
                process.next();
            });
        }
        return this;
    }

    public TaskPool addLast(Runnable ... task) {
        for (Runnable t : task) {
            this.tasks.addLast(process -> {
                t.run();
                process.next();
            });
        }
        return this;
    }

    public Consumer<TaskProcess> pollTask() {
        return this.tasks.poll();
    }

    public int getStage() {
        return this.stage;
    }
}

