/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.minecraft.gui.simple;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.Button;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.ButtonMap;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.DisplayButton;
import me.hsgamer.bettergui.lib.core.minecraft.gui.object.InventorySize;
import me.hsgamer.bettergui.lib.core.ui.property.Initializable;
import org.jetbrains.annotations.NotNull;

public class SimpleButtonMap
implements ButtonMap {
    private final Map<Button, Collection<Integer>> buttonSlotMap = new LinkedHashMap<Button, Collection<Integer>>();
    private Button defaultButton = Button.EMPTY;

    public void setButton(int slot, @NotNull Button button) {
        this.buttonSlotMap.computeIfAbsent(button, b -> new LinkedList()).add(slot);
    }

    public void removeButton(int slot) {
        this.buttonSlotMap.values().forEach(list -> list.removeIf(i -> i == slot));
    }

    @NotNull
    public Collection<Button> removeAllButton() {
        LinkedList<Button> buttons = new LinkedList<Button>(this.buttonSlotMap.keySet());
        this.buttonSlotMap.values().forEach(Collection::clear);
        this.buttonSlotMap.clear();
        return buttons;
    }

    @NotNull
    public Collection<Button> getButtons(int slot) {
        return ((Stream)this.buttonSlotMap.entrySet().stream().parallel()).filter(entry -> ((Collection)entry.getValue()).contains(slot)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public Map<Button, Collection<Integer>> getButtonSlotMap() {
        return Collections.unmodifiableMap(this.buttonSlotMap);
    }

    @NotNull
    public Button getDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(@NotNull Button defaultButton) {
        this.defaultButton = defaultButton;
    }

    @Override
    public void stop() {
        this.removeAllButton().forEach(Initializable::stop);
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull Integer, @NotNull DisplayButton> getButtons(@NotNull UUID uuid, InventorySize inventorySize) {
        HashMap<Integer, DisplayButton> map = new HashMap<Integer, DisplayButton>();
        IntFunction<DisplayButton> getDisplayButton = i -> map.computeIfAbsent(i, s -> new DisplayButton());
        Button defaultButton = this.getDefaultButton();
        DisplayButton defaultDisplayButton = defaultButton.display(uuid);
        if (defaultDisplayButton != null) {
            inventorySize.getSlots().forEach(i -> ((DisplayButton)getDisplayButton.apply(i)).apply(defaultDisplayButton));
        }
        this.buttonSlotMap.forEach((button, slots) -> {
            DisplayButton displayButton = button.display(uuid);
            if (displayButton == null) {
                return;
            }
            slots.forEach(slot -> ((DisplayButton)getDisplayButton.apply((int)slot)).apply(displayButton));
        });
        return map;
    }
}

