/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.minecraft.gui.button.impl;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import java.util.function.Predicate;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.Button;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.DisplayButton;
import me.hsgamer.bettergui.lib.core.minecraft.gui.event.ClickEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PredicateButton
implements Button {
    private final Set<UUID> clickCheckList = new ConcurrentSkipListSet<UUID>();
    private Button button = EMPTY;
    private Button fallbackButton = EMPTY;
    private Predicate<UUID> viewPredicate = uuid -> true;
    private Function<ClickEvent, CompletableFuture<Boolean>> clickFuturePredicate = clickEvent -> CompletableFuture.completedFuture(true);
    private boolean preventSpamClick = false;

    @Contract(value="_ -> this")
    public PredicateButton setViewPredicate(@NotNull @NotNull Predicate<@NotNull UUID> viewPredicate) {
        this.viewPredicate = viewPredicate;
        return this;
    }

    @Contract(value="_ -> this")
    public PredicateButton setClickPredicate(@NotNull @NotNull Predicate<@NotNull ClickEvent> clickPredicate) {
        this.clickFuturePredicate = clickEvent -> CompletableFuture.supplyAsync(() -> clickPredicate.test((ClickEvent)clickEvent));
        return this;
    }

    @Contract(value="_ -> this")
    public PredicateButton setClickFuturePredicate(@NotNull @NotNull Function<@NotNull ClickEvent, @NotNull CompletableFuture<@NotNull Boolean>> clickFuturePredicate) {
        this.clickFuturePredicate = clickFuturePredicate;
        return this;
    }

    @Contract(value="_ -> this")
    public PredicateButton setPreventSpamClick(boolean preventSpamClick) {
        this.preventSpamClick = preventSpamClick;
        return this;
    }

    public Button getButton() {
        return this.button;
    }

    @Contract(value="_ -> this")
    public PredicateButton setButton(@NotNull Button button) {
        this.button = button;
        return this;
    }

    public Button getFallbackButton() {
        return this.fallbackButton;
    }

    @Contract(value="_ -> this")
    public PredicateButton setFallbackButton(@NotNull Button fallbackButton) {
        this.fallbackButton = fallbackButton;
        return this;
    }

    @Override
    public DisplayButton display(@NotNull UUID uuid) {
        DisplayButton displayButton = this.viewPredicate.test(uuid) ? this.button.display(uuid) : this.fallbackButton.display(uuid);
        if (displayButton == null) {
            return null;
        }
        Optional.ofNullable(displayButton.getAction()).map(displayButtonAction -> event -> {
            if (event instanceof ClickEvent) {
                ClickEvent clickEvent = (ClickEvent)event;
                if (this.preventSpamClick && this.clickCheckList.contains(uuid)) {
                    return;
                }
                this.clickCheckList.add(uuid);
                this.clickFuturePredicate.apply(clickEvent).thenAccept(result -> {
                    this.clickCheckList.remove(uuid);
                    if (Boolean.TRUE.equals(result)) {
                        displayButtonAction.accept(event);
                    }
                });
            } else {
                displayButtonAction.accept(event);
            }
        }).ifPresent(displayButton::setAction);
        return displayButton;
    }

    @Override
    public void init() {
        this.button.init();
        this.fallbackButton.init();
    }

    @Override
    public void stop() {
        this.button.stop();
        this.fallbackButton.stop();
    }
}

