/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.minecraft.gui;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import me.hsgamer.bettergui.lib.core.minecraft.gui.GUIDisplay;
import me.hsgamer.bettergui.lib.core.minecraft.gui.GUIHolder;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.DisplayButton;
import me.hsgamer.bettergui.lib.core.minecraft.gui.event.ClickEvent;
import me.hsgamer.bettergui.lib.core.minecraft.gui.event.ViewerEvent;
import me.hsgamer.bettergui.lib.core.minecraft.gui.object.InventorySize;
import me.hsgamer.bettergui.lib.core.minecraft.gui.object.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryGUIDisplay<H extends GUIHolder<?>>
extends GUIDisplay<H> {
    private final AtomicReference<Map<Integer, DisplayButton>> viewedButtonsRef = new AtomicReference(Collections.emptyMap());

    protected InventoryGUIDisplay(@NotNull UUID uuid, @NotNull H holder) {
        super(uuid, holder);
    }

    protected abstract void initInventory();

    protected abstract void clearInventory();

    protected abstract InventorySize getInventorySize();

    protected abstract void setButton(int var1, @Nullable Item var2);

    @Override
    public void handleEvent(ViewerEvent event) {
        if (event instanceof ClickEvent) {
            ClickEvent clickEvent = (ClickEvent)event;
            this.getViewedButton(clickEvent.getSlot()).map(DisplayButton::getAction).ifPresent(consumer -> consumer.accept(clickEvent));
        }
    }

    @Override
    public void init() {
        this.initInventory();
        this.update();
    }

    @Override
    public void stop() {
        this.clearInventory();
        this.viewedButtonsRef.set(Collections.emptyMap());
    }

    @Override
    public void update() {
        InventorySize size = this.getInventorySize();
        Map<Integer, DisplayButton> viewedButtons = ((GUIHolder)this.holder).getButtonMap().getButtons(this.uuid, size);
        this.viewedButtonsRef.set(viewedButtons);
        size.getSlots().forEach(slot -> this.setButton(slot, viewedButtons.getOrDefault(slot, DisplayButton.EMPTY).getItem()));
    }

    public Optional<DisplayButton> getViewedButton(int slot) {
        return Optional.ofNullable(this.viewedButtonsRef.get()).map(viewedButtons -> (DisplayButton)viewedButtons.get(slot));
    }

    public Map<Integer, DisplayButton> getViewedButtons() {
        return Optional.ofNullable(this.viewedButtonsRef.get()).map(Collections::unmodifiableMap).orElse(Collections.emptyMap());
    }
}

