/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.minecraft.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.hsgamer.bettergui.lib.core.minecraft.gui.GUIDisplay;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.ButtonMap;
import me.hsgamer.bettergui.lib.core.minecraft.gui.event.ClickEvent;
import me.hsgamer.bettergui.lib.core.minecraft.gui.event.CloseEvent;
import me.hsgamer.bettergui.lib.core.minecraft.gui.event.OpenEvent;
import me.hsgamer.bettergui.lib.core.minecraft.gui.event.ViewerEvent;
import me.hsgamer.bettergui.lib.core.ui.BaseHolder;
import org.jetbrains.annotations.NotNull;

public abstract class GUIHolder<D extends GUIDisplay<?>>
extends BaseHolder<D> {
    @NotNull
    private ButtonMap buttonMap = (uuid, size) -> Collections.emptyMap();

    @NotNull
    public ButtonMap getButtonMap() {
        return this.buttonMap;
    }

    public void setButtonMap(@NotNull ButtonMap buttonMap) {
        this.buttonMap = buttonMap;
    }

    @Override
    public void init() {
        this.addEventConsumer(OpenEvent.class, this::onOpen);
        this.addEventConsumer(ClickEvent.class, this::onClick);
        this.addEventConsumer(ClickEvent.class, event -> {
            if (event.isButtonExecute()) {
                this.getDisplay(event.getViewerID()).ifPresent(guiDisplay -> guiDisplay.handleEvent((ViewerEvent)event));
            }
        });
        this.addEventConsumer(CloseEvent.class, this::onClose);
        this.addEventConsumer(CloseEvent.class, event -> {
            if (event.isRemoveDisplay()) {
                this.removeDisplay(event.getViewerID());
            }
        });
        this.buttonMap.init();
    }

    @Override
    public void stop() {
        ArrayList displays = new ArrayList(this.displayMap.values());
        super.stop();
        this.closeAll(displays);
        this.buttonMap.stop();
    }

    protected void onOpen(@NotNull OpenEvent event) {
    }

    protected void onClick(@NotNull ClickEvent event) {
    }

    protected void onClose(@NotNull CloseEvent event) {
    }

    protected void closeAll(List<D> displays) {
    }
}

