/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.expansion.extra.manager;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import me.hsgamer.bettergui.lib.core.expansion.common.ExpansionClassLoader;
import me.hsgamer.bettergui.lib.core.expansion.common.exception.InvalidExpansionDescriptionException;

public interface DependableExpansionSortAndFilter
extends UnaryOperator<Map<String, ExpansionClassLoader>> {
    public List<String> getDependencies(ExpansionClassLoader var1);

    public List<String> getSoftDependencies(ExpansionClassLoader var1);

    default public Comparator<Map.Entry<String, ExpansionClassLoader>> getDependencyComparator() {
        return (entry1, entry2) -> {
            ExpansionClassLoader loader1 = (ExpansionClassLoader)entry1.getValue();
            String name1 = (String)entry1.getKey();
            List<String> depends1 = this.getDependencies(loader1);
            List<String> softDepends1 = this.getSoftDependencies(loader1);
            ExpansionClassLoader loader2 = (ExpansionClassLoader)entry2.getValue();
            String name2 = (String)entry2.getKey();
            List<String> depends2 = this.getDependencies(loader2);
            List<String> softDepends2 = this.getSoftDependencies(loader2);
            depends1 = depends1 == null ? Collections.emptyList() : depends1;
            softDepends1 = softDepends1 == null ? Collections.emptyList() : softDepends1;
            depends2 = depends2 == null ? Collections.emptyList() : depends2;
            List<Object> list = softDepends2 = softDepends2 == null ? Collections.emptyList() : softDepends2;
            if (depends1.contains(name2) || softDepends1.contains(name2)) {
                return 1;
            }
            if (depends2.contains(name1) || softDepends2.contains(name1)) {
                return -1;
            }
            return 0;
        };
    }

    @Override
    default public Map<String, ExpansionClassLoader> apply(Map<String, ExpansionClassLoader> original) {
        LinkedHashMap<String, ExpansionClassLoader> sorted = new LinkedHashMap<String, ExpansionClassLoader>();
        HashMap remaining = new HashMap();
        Consumer<Map.Entry> consumer = entry -> {
            ExpansionClassLoader loader = (ExpansionClassLoader)entry.getValue();
            if (this.getDependencies(loader).isEmpty() && this.getSoftDependencies(loader).isEmpty()) {
                sorted.put((String)entry.getKey(), (ExpansionClassLoader)entry.getValue());
            } else {
                remaining.put((String)entry.getKey(), (ExpansionClassLoader)entry.getValue());
            }
        };
        original.entrySet().forEach(consumer);
        if (remaining.isEmpty()) {
            return sorted;
        }
        remaining.entrySet().stream().filter(entry -> {
            ExpansionClassLoader loader = (ExpansionClassLoader)entry.getValue();
            String name = (String)entry.getKey();
            List<String> depends = this.getDependencies(loader);
            if (depends.isEmpty()) {
                return true;
            }
            for (String depend : depends) {
                if (original.containsKey(depend)) continue;
                loader.setThrowable(new InvalidExpansionDescriptionException("Missing dependency for " + name + ": " + depend));
                return false;
            }
            return true;
        }).sorted(this.getDependencyComparator()).forEach(entry -> sorted.put((String)entry.getKey(), (ExpansionClassLoader)entry.getValue()));
        return sorted;
    }
}

