/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.expansion.common.factory;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.jar.JarFile;
import me.hsgamer.bettergui.lib.core.expansion.common.ExpansionDescription;
import me.hsgamer.bettergui.lib.core.expansion.common.exception.InvalidExpansionDescriptionException;

public interface MapExpansionDescriptionLoader
extends Function<JarFile, ExpansionDescription> {
    public Map<String, Object> applyAsMap(JarFile var1);

    @Override
    default public ExpansionDescription apply(JarFile jarFile) {
        Map<String, Object> data = this.applyAsMap(jarFile);
        String name = Objects.toString(data.get("name"), null);
        String version = Objects.toString(data.get("version"), null);
        String mainClass = Objects.toString(data.get("main"), null);
        if (name == null) {
            throw new InvalidExpansionDescriptionException(jarFile.getName() + " doesn't define a name");
        }
        if (version == null) {
            throw new InvalidExpansionDescriptionException(jarFile.getName() + " doesn't define a version");
        }
        if (mainClass == null) {
            throw new IllegalArgumentException(jarFile.getName() + " doesn't define a main class");
        }
        return ExpansionDescription.simple(name, version, mainClass, data);
    }
}

