/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.downloader.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.hsgamer.bettergui.lib.core.downloader.core.Downloader;
import me.hsgamer.bettergui.lib.core.downloader.core.loader.MapDownloadInfoLoader;
import me.hsgamer.bettergui.lib.core.gson.GsonUtils;
import me.hsgamer.bettergui.lib.core.web.UserAgent;
import me.hsgamer.bettergui.lib.core.web.WebUtils;

public class JsonDownloadInfoLoader
extends MapDownloadInfoLoader {
    private final String dbUrl;
    private final UserAgent userAgent;

    public JsonDownloadInfoLoader(String dbUrl, UserAgent userAgent) {
        this.dbUrl = dbUrl;
        this.userAgent = userAgent;
    }

    public JsonDownloadInfoLoader(String dbUrl) {
        this(dbUrl, UserAgent.FIREFOX);
    }

    @Override
    protected CompletableFuture<Map<String, Map<String, Object>>> loadMap(Downloader downloader) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return new InputStreamReader(WebUtils.createConnection(this.dbUrl, this.userAgent::assignToConnection).getInputStream());
            }
            catch (IOException e) {
                throw new IllegalStateException("Something wrong when getting the info", e);
            }
        }).thenApplyAsync(inputStreamReader -> {
            try {
                return GsonUtils.parse(inputStreamReader);
            }
            catch (Exception e) {
                throw new IllegalStateException("Something wrong when parsing the info", e);
            }
        })).thenApplyAsync(element -> {
            if (!element.isJsonObject()) {
                return Collections.emptyMap();
            }
            JsonObject jsonObject = element.getAsJsonObject();
            HashMap map = new HashMap();
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
                HashMap<String, String> infoMap = new HashMap<String, String>();
                for (Map.Entry infoEntry : object.entrySet()) {
                    infoMap.put((String)infoEntry.getKey(), ((JsonElement)infoEntry.getValue()).getAsString());
                }
                map.put((String)entry.getKey(), infoMap);
            }
            return map;
        });
    }
}

