/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.checker.spigotmc;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.CompletableFuture;
import me.hsgamer.bettergui.lib.core.checker.VersionChecker;
import me.hsgamer.bettergui.lib.core.gson.GsonUtils;
import me.hsgamer.bettergui.lib.core.web.UserAgent;
import me.hsgamer.bettergui.lib.core.web.WebUtils;
import org.jetbrains.annotations.NotNull;

public final class SpigotVersionChecker
implements VersionChecker {
    private final int resourceId;
    private final UserAgent userAgent;

    public SpigotVersionChecker(int resourceId, UserAgent userAgent) {
        this.resourceId = resourceId;
        this.userAgent = userAgent;
    }

    public SpigotVersionChecker(int resourceId) {
        this(resourceId, UserAgent.FIREFOX);
    }

    @Override
    @NotNull
    public CompletableFuture<String> getVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream inputStream = WebUtils.createConnection("https://api.spigotmc.org/simple/0.1/index.php?action=getResource&id=" + this.resourceId, this.userAgent::assignToConnection).getInputStream();){
                String string;
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    JsonElement element = GsonUtils.parse(reader);
                    if (!element.isJsonObject()) {
                        throw new IOException("Invalid JSON");
                    }
                    JsonElement currentVersion = element.getAsJsonObject().get("current_version");
                    if (currentVersion == null) {
                        throw new IOException("Cannot get the plugin version");
                    }
                    string = currentVersion.getAsString();
                }
                return string;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

