/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.utils;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class BukkitUtils {
    private static final Function<Player, Integer> PING_PLAYER;

    private BukkitUtils() {
    }

    public static int getPing(@NotNull Player player) {
        return PING_PLAYER.apply(player);
    }

    @NotNull
    public static List<UUID> getAllUniqueIds() {
        return ((Stream)Arrays.stream(Bukkit.getOfflinePlayers()).parallel()).map(OfflinePlayer::getUniqueId).collect(Collectors.toList());
    }

    @NotNull
    public static List<String> getAllPlayerNames() {
        return ((Stream)Arrays.stream(Bukkit.getOfflinePlayers()).parallel()).map(OfflinePlayer::getName).collect(Collectors.toList());
    }

    @NotNull
    public static List<String> getMissingDepends(@NotNull List<String> depends) {
        return depends.stream().filter(depend -> Bukkit.getPluginManager().getPlugin(depend) == null).collect(Collectors.toList());
    }

    public static Location centerLocation(Location location, boolean centerX, boolean centerY, boolean centerZ) {
        return new Location(location.getWorld(), (double)location.getBlockX() + (centerX ? 0.5 : 0.0), (double)location.getBlockY() + (centerY ? 0.5 : 0.0), (double)location.getBlockZ() + (centerZ ? 0.5 : 0.0), location.getYaw(), location.getPitch());
    }

    public static Location centerLocation(Location location) {
        return BukkitUtils.centerLocation(location, true, true, true);
    }

    public static float normalizeDegree(float degree) {
        return (float)Math.round(degree / 90.0f) * 90.0f;
    }

    public static Location normalizeYawPitch(Location location) {
        return new Location(location.getWorld(), location.getX(), location.getY(), location.getZ(), BukkitUtils.normalizeDegree(location.getYaw()), BukkitUtils.normalizeDegree(location.getPitch()));
    }

    static {
        Function<Player, Integer> pingPlayer;
        try {
            Method pingMethod = Player.class.getDeclaredMethod("getPing", new Class[0]);
            pingPlayer = player -> {
                try {
                    return (int)((Integer)pingMethod.invoke(player, new Object[0]));
                }
                catch (Exception e) {
                    return -1;
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            pingPlayer = player -> {
                try {
                    Object entityPlayer = player.getClass().getMethod("getHandle", new Class[0]).invoke(player, new Object[0]);
                    return entityPlayer.getClass().getField("ping").getInt(entityPlayer);
                }
                catch (Exception e) {
                    Bukkit.getServer().getLogger().log(Level.WARNING, "Unexpected error when getting ping", e);
                    return -9;
                }
            };
        }
        PING_PLAYER = pingPlayer;
    }
}

