/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.item.modifier;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.ItemMetaComparator;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.ItemMetaModifier;
import me.hsgamer.bettergui.lib.core.common.CollectionUtils;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.common.Validate;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionEffectModifier
implements ItemMetaModifier,
ItemMetaComparator {
    private List<String> potionEffectList = Collections.emptyList();

    private static Optional<PotionEffect> pastePotionEffect(String string) {
        String[] split = string.indexOf(44) != -1 ? string.split(",", 3) : string.split(" ", 3);
        PotionEffectType potionEffectType = PotionEffectType.getByName((String)split[0].replace(" ", "_").trim());
        if (potionEffectType == null) {
            return Optional.empty();
        }
        int duration = 2400;
        int amplifier = 0;
        if (split.length > 1) {
            duration = Validate.getNumber(split[1].trim()).map(BigDecimal::intValue).map(i -> i * 20).orElse(duration);
        }
        if (split.length > 2) {
            amplifier = Validate.getNumber(split[2].trim()).map(BigDecimal::intValue).orElse(amplifier);
        }
        return Optional.of(new PotionEffect(potionEffectType, duration, amplifier));
    }

    private static String serializePotionEffect(PotionEffect potionEffect) {
        return potionEffect.getType().getName() + ", " + potionEffect.getDuration() + ", " + potionEffect.getAmplifier();
    }

    private List<PotionEffect> getParsed(UUID uuid, StringReplacer stringReplacer) {
        ArrayList<String> list = new ArrayList<String>(this.potionEffectList);
        list.replaceAll(s -> stringReplacer.replaceOrOriginal((String)s, uuid));
        return list.stream().map(PotionEffectModifier::pastePotionEffect).flatMap(optional -> optional.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public ItemMeta modifyMeta(@NotNull ItemMeta meta, @Nullable UUID uuid, @NotNull StringReplacer stringReplacer) {
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            this.getParsed(uuid, stringReplacer).forEach(potionEffect -> potionMeta.addCustomEffect(potionEffect, true));
            return potionMeta;
        }
        return meta;
    }

    @Override
    public boolean loadFromItemMeta(ItemMeta meta) {
        if (!(meta instanceof PotionMeta)) {
            return false;
        }
        this.potionEffectList = ((PotionMeta)meta).getCustomEffects().stream().map(PotionEffectModifier::serializePotionEffect).collect(Collectors.toList());
        return true;
    }

    @Override
    public boolean compare(@NotNull ItemMeta meta, @Nullable UUID uuid, @NotNull StringReplacer stringReplacer) {
        if (!(meta instanceof PotionMeta)) {
            return false;
        }
        HashSet<PotionEffect> list1 = new HashSet<PotionEffect>(this.getParsed(uuid, stringReplacer));
        List list2 = ((PotionMeta)meta).getCustomEffects();
        return list1.size() == list2.size() && list1.containsAll(list2);
    }

    @Override
    public Object toObject() {
        return this.potionEffectList;
    }

    @Override
    public void loadFromObject(Object object) {
        this.potionEffectList = CollectionUtils.createStringListFromObject(object, true);
    }

    @Contract(value="_ -> this")
    public PotionEffectModifier setPotionEffect(List<String> potionEffect) {
        this.potionEffectList = potionEffect;
        return this;
    }

    @Contract(value="_ -> this")
    public PotionEffectModifier setPotionEffect(String ... potionEffect) {
        return this.setPotionEffect(Arrays.asList(potionEffect));
    }

    @Contract(value="_ -> this")
    public PotionEffectModifier setPotionEffect(Collection<PotionEffect> potionEffect) {
        return this.setPotionEffect(potionEffect.stream().map(PotionEffectModifier::serializePotionEffect).collect(Collectors.toList()));
    }

    @Contract(value="_ -> this")
    public PotionEffectModifier setPotionEffect(PotionEffect ... potionEffect) {
        return this.setPotionEffect((Collection<PotionEffect>)Arrays.asList(potionEffect));
    }
}

