/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.item.modifier;

import java.util.UUID;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.ItemMetaComparator;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.ItemMetaModifier;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameModifier
implements ItemMetaModifier,
ItemMetaComparator {
    private String name;

    @Contract(value="_ -> this")
    public NameModifier setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @NotNull
    public ItemMeta modifyMeta(@NotNull ItemMeta meta, @Nullable UUID uuid, @NotNull StringReplacer stringReplacer) {
        if (this.name != null) {
            meta.setDisplayName(stringReplacer.replaceOrOriginal(this.name, uuid));
        }
        return meta;
    }

    @Override
    public boolean loadFromItemMeta(ItemMeta meta) {
        if (meta.hasDisplayName()) {
            this.name = meta.getDisplayName();
            return true;
        }
        return false;
    }

    @Override
    public boolean compare(@NotNull ItemMeta meta, @Nullable UUID uuid, @NotNull StringReplacer stringReplacer) {
        if (!meta.hasDisplayName() && this.name == null) {
            return true;
        }
        String replaced = this.name == null ? "" : stringReplacer.replaceOrOriginal(this.name, uuid);
        return replaced.equals(meta.getDisplayName());
    }

    @Override
    public Object toObject() {
        return this.name;
    }

    @Override
    public void loadFromObject(Object object) {
        this.name = String.valueOf(object);
    }
}

