/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.item.modifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.ItemMetaComparator;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.ItemMetaModifier;
import me.hsgamer.bettergui.lib.core.common.CollectionUtils;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoreModifier
implements ItemMetaModifier,
ItemMetaComparator {
    private final List<String> lore = new ArrayList<String>();

    private List<String> getReplacedLore(UUID uuid, StringReplacer stringReplacer) {
        ArrayList<String> replacedLore = new ArrayList<String>(this.lore);
        replacedLore.replaceAll(s -> stringReplacer.replaceOrOriginal((String)s, uuid));
        return replacedLore;
    }

    @Override
    @NotNull
    public ItemMeta modifyMeta(@NotNull ItemMeta meta, @Nullable UUID uuid, @NotNull StringReplacer stringReplacer) {
        meta.setLore(this.getReplacedLore(uuid, stringReplacer));
        return meta;
    }

    @Override
    public boolean loadFromItemMeta(ItemMeta meta) {
        if (meta.hasLore()) {
            this.setLore(meta.getLore());
            return true;
        }
        return false;
    }

    @Override
    public boolean compare(@NotNull ItemMeta meta, @Nullable UUID uuid, @NotNull StringReplacer stringReplacer) {
        return !meta.hasLore() && this.lore.isEmpty() || this.getReplacedLore(uuid, stringReplacer).equals(meta.getLore());
    }

    @Override
    public Object toObject() {
        return this.lore;
    }

    @Override
    public void loadFromObject(Object object) {
        this.setLore(CollectionUtils.createStringListFromObject(object, false));
    }

    @Contract(value="_ -> this")
    public LoreModifier setLore(String ... lore) {
        return this.setLore(Arrays.asList(lore));
    }

    @Contract(value="_ -> this")
    public LoreModifier addLore(String lore) {
        this.lore.addAll(Arrays.asList(lore.split("\\n")));
        return this;
    }

    @Contract(value="_ -> this")
    public LoreModifier setLore(Collection<String> lore) {
        this.clearLore();
        this.lore.addAll(CollectionUtils.splitAll("\\n", lore));
        return this;
    }

    @Contract(value=" -> this")
    public LoreModifier clearLore() {
        this.lore.clear();
        return this;
    }
}

