/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.item.modifier;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.ItemMetaComparator;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.ItemMetaModifier;
import me.hsgamer.bettergui.lib.core.common.CollectionUtils;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.common.Validate;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantmentModifier
implements ItemMetaModifier,
ItemMetaComparator {
    private static final Map<String, Enchantment> ENCHANTMENT_MAP = new HashMap<String, Enchantment>();
    private List<String> enchantmentList = Collections.emptyList();

    private static String normalizeEnchantmentName(String name) {
        return name.toUpperCase(Locale.ROOT).replace(" ", "_");
    }

    private Map<Enchantment, Integer> getParsed(UUID uuid, StringReplacer stringReplacer) {
        LinkedHashMap<Enchantment, Integer> enchantments = new LinkedHashMap<Enchantment, Integer>();
        for (String string : this.enchantmentList) {
            String replaced = stringReplacer.replaceOrOriginal(string, uuid);
            String[] split = replaced.indexOf(44) != -1 ? replaced.split(",", 2) : replaced.split(" ", 2);
            Optional<Enchantment> enchantment = Optional.of(split[0].trim()).map(EnchantmentModifier::normalizeEnchantmentName).map(ENCHANTMENT_MAP::get);
            int level = 1;
            if (split.length > 1) {
                String rawLevel = split[1].trim();
                Optional<BigDecimal> optional = Validate.getNumber(rawLevel);
                if (!optional.isPresent()) continue;
                level = optional.get().intValue();
            }
            if (!enchantment.isPresent()) continue;
            enchantments.put(enchantment.get(), level);
        }
        return enchantments;
    }

    @Override
    @NotNull
    public ItemMeta modifyMeta(@NotNull ItemMeta meta, @Nullable UUID uuid, @NotNull StringReplacer stringReplacer) {
        Map<Enchantment, Integer> map = this.getParsed(uuid, stringReplacer);
        if (map instanceof EnchantmentStorageMeta) {
            map.forEach((enchant, level) -> ((EnchantmentStorageMeta)meta).addStoredEnchant(enchant, level.intValue(), true));
        } else {
            map.forEach((enchantment, level) -> meta.addEnchant(enchantment, level.intValue(), true));
        }
        return meta;
    }

    @Override
    public boolean loadFromItemMeta(ItemMeta meta) {
        Map map;
        if (meta instanceof EnchantmentStorageMeta) {
            map = ((EnchantmentStorageMeta)meta).getStoredEnchants();
        } else if (meta.hasEnchants()) {
            map = meta.getEnchants();
        } else {
            return false;
        }
        this.enchantmentList = map.entrySet().stream().map(entry -> ((Enchantment)entry.getKey()).getName() + ", " + entry.getValue()).collect(Collectors.toList());
        return true;
    }

    @Override
    public boolean compare(@NotNull ItemMeta meta, @Nullable UUID uuid, @NotNull StringReplacer stringReplacer) {
        Map<Enchantment, Integer> list1 = this.getParsed(uuid, stringReplacer);
        Map list2 = meta.getEnchants();
        if (list1.size() != list2.size()) {
            return false;
        }
        for (Map.Entry<Enchantment, Integer> entry : list1.entrySet()) {
            Enchantment enchantment = entry.getKey();
            int lvl = entry.getValue();
            if (list2.containsKey(enchantment) && (Integer)list2.get(enchantment) == lvl) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object toObject() {
        return this.enchantmentList;
    }

    @Override
    public void loadFromObject(Object object) {
        this.enchantmentList = CollectionUtils.createStringListFromObject(object, true);
    }

    @Contract(value="_, _ -> this")
    public EnchantmentModifier addEnchantment(String enchantment, int level) {
        this.enchantmentList.add(enchantment + ", " + level);
        return this;
    }

    @Contract(value="_, _ -> this")
    public EnchantmentModifier addEnchantment(Enchantment enchantment, int level) {
        this.enchantmentList.add(EnchantmentModifier.normalizeEnchantmentName(enchantment.getName()) + ", " + level);
        return this;
    }

    @Contract(value="_ -> this")
    public EnchantmentModifier addEnchantment(String enchantment) {
        this.enchantmentList.add(enchantment);
        return this;
    }

    @Contract(value="_ -> this")
    public EnchantmentModifier addEnchantment(Enchantment enchantment) {
        this.enchantmentList.add(EnchantmentModifier.normalizeEnchantmentName(enchantment.getName()));
        return this;
    }

    static {
        for (Enchantment enchantment : Enchantment.values()) {
            ENCHANTMENT_MAP.put(EnchantmentModifier.normalizeEnchantmentName(enchantment.getName()), enchantment);
        }
    }
}

